<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
//ini_set('session.save_path', '/tmp');
ini_set('error_reporting', E_ALL & ~E_NOTICE & ~E_WARNING);
ini_set('display_errors', E_ALL & ~E_NOTICE & ~E_WARNING);

use FwRoutingSystem\Router;
use model\PaymentTable;
use payment\BasePayment;
use FwAuthSystem\Main\Auth;
use site\helpers\ParsianPayment;
use FwAuthSystem\Utils\AuthConfig;
use FwHtml\Elements\Tags\Main\HtmlTags;
use Pasargad\Pasargad;
use Pasargad\Classes\PaymentItem;

include 'src/autoload.php';
define('__HOST__', FwConfig::HOST());

define('__IMAGES__', 'https://img.boosar.ir/');
$Router = new Router();


function creditDetails($customerId, $type, $amount, $lastCredit, $description){
    if($type == 1) $newCredit =  $lastCredit + $amount;
    if($type == 2) $newCredit = $lastCredit - $amount;
//    if($newCredit < 0) $newCredit = 0;
    \model\CreditDetails::add([
        'customer_id' => $customerId,
        'credit_type' => $type,
        'credit_amount' => $amount,
        'credit_before' => $lastCredit,
        'credit_after' => $newCredit,
        'credit_descriptiom' => $description
    ]);
}

$Router->any('/test', function () {
    try {
        $pasargad = new Pasargad(
            "5172378",
            "2438349",
            "http://yoursite.com/redirect-url-here/",
            __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'Pasargad/cert.xml',
        );
        //e.q:
        // $pasargad = new Pasargad(123456,555555,"http://pep.co.ir/ipgtest","../cert/cert.xml");

        // Set Amount
        $pasargad->setAmount(100000);

        // Set Invoice Number (it MUST BE UNIQUE)
        $pasargad->setInvoiceNumber(4029);

        // set Invoice Date with below format (Y/m/d H:i:s)
        $pasargad->setInvoiceDate(date("Y/m/d H:i:s"));

        // Optional Parameters
        // ----------------------
        // User's Mobile and Email:
        $pasargad->setMobile("09121001234");
        $pasargad->setEmail("user@email.com");


        // IF YOU HAVE ACTIVATED "TAS-HIM" (تسهیم پرداخت), ADD SHABA AND PAYMENT SHARING PERCENTAGE/VALUE LIKE THIS:
        // شروع تسهیم ---------------------------------------------
        // فقط در صورتیکه قابلیت تسهیم شاپرکی را روی درگاه خود
        // فعال کرده‌اید از متد addPaymentType استفاده کنید.

        // تسهیم درصدی ۲۰ به ۸۰:
//    $this->pasargad->addPaymentType("IR300570023980000000000000",PaymentItem::BY_PERCENTAGE, 20);
//    $this->pasargad->addPaymentType("IR070570022080000000000001",PaymentItem::BY_PERCENTAGE, 80);

        // تسهیم مبلغی:
//    $this->pasargad->addPaymentType("IR300570023980000000000000",PaymentItem::BY_VALUE, 20000);
//    $this->pasargad->addPaymentType("IR070570022080000000000001",PaymentItem::BY_VALUE, 80000);
        // پایان تسهیم --------------------------------------------


        // get the Generated RedirectUrl from Pasargad API:
        $redirectUrl = $pasargad->redirect();
//        var_dump($redirectUrl);
        // output example: https://pep.shaparak.ir/payment.aspx?n=bPo+Z8GLB4oh5W0KVNohihxCu1qBB3kziabGvO1xqg8Y=

        // and redirect user to payment gateway:
//        var_dump($redirectUrl);
        header("Location: $redirectUrl");

        // ...or in Laravel/Symfony Controller (Controller extends Symfony\Component\HttpFoundation\Response):
//        return $this->redirect($redirectUrl);
    } catch (\Exception $ex) {
        var_dump($ex->getMessage());
        die();
    }
});

$Router->any('/callback', function () {
    if ($_REQUEST['IsSuccess'] == 0) {
        include __SOURCE__ . '../callback-fail.php';
    } else {
        $payment = new AllSatPayment();
        $payment->PaymentModel = new PaymentTable();
        $payment->update(strtotime($_REQUEST['iD']), $_REQUEST['iN']);
        $payment->confirm($_REQUEST["iN"], $_REQUEST['iD'], $_REQUEST['tref']);
        include __SOURCE__ . '../callback-success.php';
    }
});

$Router->get('/$|/index', function () {
    include 'src/index.php';
});

$Router->any('/sign-out', function () {
    Auth::end();
    header('location: /');
});
$Router->error(function () {
    echo HtmlTags::Section('.content')
        ->Content(
            HtmlTags::Div('.row')
                ->Content(
                    HtmlTags::Div('.col-md-12')->Content(
                        HtmlTags::Div('.card.card-warning.card-outline')
                            ->Content(
                                HtmlTags::Div('.card-header.d-flex.flex-wrap')
                                    ->Content(
                                        HtmlTags::I('.fa.fa-warning.m-2'),
                                        HtmlTags::H3('صفحه ی مورد نظر یافت نشد!')
                                    ),
                                HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                    ->Content(
                                        'صفحه ی مورد نظر در حال طراحی است، از شکیبایی شما متشکریم!'
                                    )
                            )
                    )
                )
        );
});
$Router->get('/login', function () {
    $Auth = Auth::init(new AuthConfig());
    include 'src/login.php';
});
$Router->post('/login', function () {
    $Auth = Auth::init(new AuthConfig());
    include 'src/login.php';
    $Auth->ProccessOnSubmit();
});
