<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CategoriesEntity;

class Categories extends ControllerScheme
{

    use ApiInterface;

    const name = 'دسته بندی ها';

    public static $__uploads = ["category_icon" => __SOURCE__ . "images/Categories/Icon"];

    public function getSubCats()
    {
        $id = $this->requestArray()['id'];
        $result = \model\Categories::getAllFiltered('parent_id', $id);
        $output = [];
        foreach ($result as $item) {
            if ($item) {
                $output[] = HtmlTags::Option()->Value($item->category_id)->Content($item->category_name);
            }
        }
        return implode('', $output);
    }

    public function getOrderCategories()
    {
        $allCats = \model\Categories::getAll();
        $output = [];
        foreach ($allCats as $item){
            $check = \model\Categories::getOneFiltered('parent_id',$item->category_id);
            if (!$check){
                $output[] =  HtmlTags::Button('.btn.btn-success.productGroupBtn')->Content(
                    $item->category_name
                )->Data_("id", $item->category_id)->Attrs(['type' => "button"]);
            }
        }
        return implode("",$output);
    }

    public function getCategories()
    {
        $cat_id = $this->ApiParam('cat_id');
        $result = \model\Categories::getAllFiltered('parent_id', $cat_id);
        $this->setIsDone();
        return $result->map(function (CategoriesEntity $result) {
            return $result->apiFormat();
        });
    }


}
