<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CitiesEntity;
use model\Entity\StatesEntity;

class Cities extends ControllerScheme
{

    use ApiInterface;

    const name = 'شهر';

    public function getCitiesByStateId()
    {
        $state_id = $this->requestArray()['state_id'];
        $outPut[]=HtmlTags::Option()->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید");
        foreach (\model\Cities::getAllFiltered('state_id',$state_id) as $item){
            $outPut[]=HtmlTags::Option()->Value($item->city_id)->Content($item->city_name);
        }
        return implode('',$outPut);
    }

    public function ApiCities()
    {
        $stateId=$this->ApiParam('stateId');
        $result=\model\Cities::getAllFiltered('state_id',$stateId);
        $this->setIsDone();
        return $result->map(function (CitiesEntity $result){
            return $result->apiFormat();
        });
    }

}
