<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\DistrictsEntity;
use model\Entity\StatesEntity;

class Districts extends ControllerScheme
{

    use ApiInterface;

    const name = 'منطقه';

    public function apiDistricts()
    {
        $cityId=$this->ApiParam('cityId');
        $result=\model\Districts::getAllFiltered('city_id',$cityId);
        $this->setIsDone();
        return $result->map(function (DistrictsEntity $result){
            return $result->apiFormat();
        });
    }

    public function getDistrictsByCityId()
    {
        $city_id = $this->requestArray()['city_id'];
        $output=[HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
        foreach (\model\Districts::getAllFiltered('city_id',$city_id) as $item){
            $output[]=HtmlTags::Option()->Value($item->district_id)->Content($item->district_name);
        }
        return implode('',$output);
    }


}
