<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\BannersEntity;
use model\Entity\BlogsEntity;

class Blogs extends ControllerScheme
{
    public static $__uploads = ["blog_image" => __SOURCE__ . "images/Blogs/"];

    use ApiInterface;

    const name = 'بلاگ';


    public function allBlogs()
    {
        $page = $this->ApiParam('page');
        $limit = $this->ApiParam('limit');

        $allBlogs = \model\Downloads::getAll();
        $count = count($allBlogs);
        $nextCount = $count - ($page * $limit);
        if ($nextCount > 0){
            $hasNext = true;
        }else{
            $hasNext = false;
        }
        $offset = ($page - 1) * $limit;
        $result = \model\Blogs::Db()->limit($limit)->offset($offset)->get();
        $this->setIsDone();
        return[
          'hasNext' => $hasNext,
          'list'=>$result->map(function (BlogsEntity $res){
              return $res->apiFormat();
          })
        ];

    }

    public function allBlogs2()
    {
        $page = $this->ApiParam('page');
        $limit = $this->ApiParam('limit');
        $checkNextOffset = ($page) * $limit;
        $checkNext =count(\model\Blogs::Db()->limit($limit)->offset($checkNextOffset)->get());
        if ($checkNext==0){
            $hasNext = false;
        }else{
            $hasNext = true;
        }
        $offset = ($page - 1) * $limit;
        $result = \model\Blogs::Db()->limit($limit)->offset($offset)->get();
        $this->setIsDone();
        return[
            'hasNext' => $hasNext,
            'list'=>$result->map(function (BlogsEntity $res){
                return $res->apiFormat();
            })
        ];

    }

    public function singleBlog()
    {
        $blog_id = $this->ApiParam('blogId');
        $res = \model\Blogs::get($blog_id);
        $this->setIsDone();
        /** @var BlogsEntity $res */
        return $res->apiFormat();
    }

    public function latestBlog()
    {
        $result = \model\Blogs::Db()->limit('4')->orderBy('category_id',true)->get();
        $this->setIsDone();
        return $result->map(function (BlogsEntity $res){
            return $res->apiFormat();
        });
    }

    public function filterBlogsByCatId(){
        $page = $this->ApiParam('page');
        $limit = $this->ApiParam('limit');
        $categoryId = $this->ApiParam('categoryId');

        $allBlogs = \model\Blogs::getAllFiltered('category_id',$categoryId);
        $count = count($allBlogs);
        $nextCount = $count - ($page * $limit);
        if ($nextCount > 0){
            $hasNext = true;
        }else{
            $hasNext = false;
        }
        $offset = ($page - 1) * $limit;
        $result = \model\Blogs::Db()->where("category_id = $categoryId")->limit($limit)->offset($offset)->get();
        $this->setIsDone();
        return[
            'hasNext' => $hasNext,
            'list'=>$result->map(function (BlogsEntity $res){
                return $res->apiFormat();
            })
        ];
    }


}
