<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\ContactUsEntity;

class ContactUs extends ControllerScheme
{

    use ApiInterface;

    const name = 'تماس با ما';

    public function edit()
    {
        $id = $this->requestArray()['contact_us_id'];
        $address = $this->requestArray()['contact_us_address'];
        $email = $this->requestArray()['contact_us_email'];
        $mobile = str_ireplace(['(', ')', ' '], ['', '', ''], $this->requestArray()['contact_us_mobile']);
        $phone = str_ireplace(['(', ')', ' '], ['', '', ''], $this->requestArray()['contact_us_phone']);
        $facebook = $this->requestArray()['contact_us_facebook'];
        $instagram = $this->requestArray()['contact_us_instagram'];
        $whatsapp = $this->requestArray()['contact_us_whatsapp'];
        $telegram = $this->requestArray()['contact_us_telegram'];
        $edit = \model\ContactUs::edit($id, [
            'contact_us_address' => $address,
            'contact_us_email'=>$email,
            'contact_us_mobile'=>$mobile,
            'contact_us_phone'=>$phone,
            'contact_us_facebook' => $facebook,
            'contact_us_instagram' => $instagram,
            'contact_us_whatsapp' => $whatsapp,
            'contact_us_telegram' => $telegram,
        ]);
        if ($edit){
            return showSuccessMsg('اطلاعات تماس','ویرایش');
        }else{
            return showErrorMsg('اطلاعات تماس','ویرایش');
        }
    }

    public function contactUs()
    {
        $result = \model\ContactUs::get(\model\ContactUs::LastId());
        $this->setIsDone();
        /** @var ContactUsEntity $result */
        return $result->apiFormat();
    }


}
