<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;

class CustomerAddresses extends ControllerScheme
{

    use ApiInterface;

    const name = 'آدرس مشتری';

    public function addAddress()
    {
        $customer_id = $this->ApiParam('customerId');
        $name = $this->ApiParam('addressName');
        $state = $this->ApiParam('stateId');
        $city = $this->ApiParam('cityId');
        $district = $this->ApiParam('districtId');
        $address = $this->ApiParam('address');
        $lat = $this->ApiParam('lat');
        $long = $this->ApiParam('long');
        $add = \model\CustomerAddresses::add([
            'customer_id' => $customer_id,
            'customer_address_name' => $name,
            'state_id' => $state,
            'city_id' => $city,
            'district_id' => $district,
            'customer_address' => $address,
            'customer_address_latitude' => $lat,
            'customer_address_longitude' => $long
        ]);
        if ($add) {
            $customer = \model\Customers::get($customer_id);
            if ($customer->customer_gender == 1) {
                $gender = "آقای";
            } else {
                $gender = "خانم";
            }
            $this->setIsDone();
            return "ثبت آدرس " . $gender . ' ' . $customer->customer_first_name . ' ' . $customer->customer_last_name . " با موفقیت انجام شد";
        }else{
            return 'عملیات با خطا مواجه شد';
        }
    }

    public function editAddress()
    {
        $id = $this->ApiParam('addressId');
        $name = $this->ApiParam('addressName');
        $state = $this->ApiParam('stateId');
        $city = $this->ApiParam('cityId');
        $district = $this->ApiParam('districtId');
        $address = $this->ApiParam('address');
        $lat = $this->ApiParam('lat');
        $long = $this->ApiParam('long');
        $edit = \model\CustomerAddresses::edit($id, [
            'customer_address_name' => $name,
            'state_id' => $state,
            'city_id' => $city,
            'district_id' => $district,
            'customer_address'=>$address,
            'customer_address_latitude'=>$lat,
            'customer_address_longitude'=>$long
        ]);
        if ($edit){
            $customer = \model\Customers::get(\model\CustomerAddresses::get($id)->customer_id);
            if ($customer->customer_gender == 1){
                $gender = "آقای";
            }else{
                $gender = "خانم";
            }
            $this->setIsDone();
            return 'ویرایش آدرس '.$gender.' '.$customer->customer_first_name.' '.$customer->customer_last_name.' با موفقیت انجام شد';
        }else{
            return 'عملیات با خطا مواجه شد';
        }
    }

    public function deleteAddress()
    {
        $id = $this->ApiParam('id');
        $delete = \model\CustomerAddresses::delete($id);
        if ($delete){
            $this->setIsDone();
            return "آدرس با موفقیت حذف شد";
        }else{
            return 'عملیات با خطا مواجه شد';
        }
    }

}
