<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\BannersEntity;

class Discounts extends ControllerScheme
{
    use ApiInterface;

    const name = 'کد تخفیف';

    public function getDiscountType()
    {
        $id = $this->requestArray()['id'];
        if ($id==1){
            return HtmlTags::Div('.input-group.mb-3')->Content(

                HtmlTags::Input('.form-control#discount_amount')->Name('discount_amount'),
                HtmlTags::Div('.input-group-prepend')->Content(
                    HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                        'تومان'
                    )
                )

            );
        }else{
            return HtmlTags::Div('.input-group.mb-3')->Content(
                HtmlTags::Div('.input-group-prepend')->Content(
                    HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                        '%'
                    )
                ),
                HtmlTags::Input('.form-control#discount_amount')->Name('discount_amount')
            );
        }
    }

}
