<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\BannersEntity;

class Levels extends ControllerScheme
{

    use ApiInterface;

    const name = 'سطح عضویت';

    protected function add(?bool $csrf = true)
    {
        $level_name = $this->requestArray()['level_name'];
        $least_price = $this->requestArray()['least_price'];
        $category_discount =$this->requestArray()['category_discount'];
        $add = \model\Levels::add([
           'level_name'=>$level_name,
           'least_price'=>$least_price,
           'discount_percent'=>json_encode($category_discount,JSON_UNESCAPED_UNICODE)
        ]);
        if ($add){
            return showSuccessMsg('سطح عضویت','افزودن');
        }else{
            return showErrorMsg('سطح عضویت','افزودن');
        }
    }

    public function edit()
    {
        $id = $this->requestArray()['level_id'];
        $level_name = $this->requestArray()['level_name'];
        $least_price = $this->requestArray()['least_price'];
        $category_discount =$this->requestArray()['category_discount'];
        $brand_discount =$this->requestArray()['brand_discount'];
        $add = \model\Levels::edit($id,[
            'level_name'=>$level_name,
            'least_price'=>$least_price,
            'discount_percent'=>json_encode($category_discount,JSON_UNESCAPED_UNICODE),
            'brand_percent'=>json_encode($brand_discount,JSON_UNESCAPED_UNICODE)
        ]);
        if ($add){
            return showSuccessMsg('سطح عضویت','ویرایش');
        }else{
            return showErrorMsg('سطح عضویت','ویرایش');
        }
//        return parent::edit(); // TODO: Change the autogenerated stub
    }


    public function getTable()
    {
        $id = $this->requestArray()['id'];
        $level = \model\Levels::get($id);
        if (!$level){
            $mainCats = \model\Categories::getAllFiltered('parent_id',0);
            $output=[];
            $i = 1;
            foreach ($mainCats as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->category_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(
                                HtmlTags::Input(".form-control.discountValue")->Name("category_discount[$item->category_id]"),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )
                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }else{
            $data = json_decode($level->discount_percent,true);

            $mainCats = \model\Categories::getAllFiltered('parent_id',0);
            $output=[];
            $i = 1;
            foreach ($mainCats as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->category_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(

                                HtmlTags::Input(".form-control.discountValue")->Name("category_discount[$item->category_id]")->Value($data[$item->category_id]?:0),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )


                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }


    }
    public function getTable2()
    {
        $id = $this->requestArray()['id'];
        $level = \model\Levels::get($id);
        if (!$level){
            $brands = \model\Brands::getAll();
            $output=[];
            $i = 1;
            foreach ($brands as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->brand_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(
                                HtmlTags::Input(".form-control.discountValue")->Name("brand_discount[$item->brand_id]"),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )
                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }else{
            $data = json_decode($level->brand_percent,true);

            $brands = \model\Brands::getAll();
            $output=[];
            $i = 1;
            foreach ($brands as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->brand_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(

                                HtmlTags::Input(".form-control.discountValue")->Name("brand_discount[$item->brand_id]")->Value($data[$item->brand_id]?:0),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )


                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }


    }

    public function getTableView()
    {
        $id = $this->requestArray()['id'];
        $level = \model\Levels::get($id);
            $data = json_decode($level->discount_percent,true);
            $mainCats = \model\Categories::getAllFiltered('parent_id',0);
            $output=[];
            $i = 1;
            foreach ($mainCats as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->category_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(

                                HtmlTags::Input(".form-control.discountValue")->Name("category_discount[$item->category_id]")->Value($data[$item->category_id]?:0)->Disabled(true),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )


                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }
    public function getTableView2()
    {
        $id = $this->requestArray()['id'];
        $level = \model\Levels::get($id);
            $data = json_decode($level->discount_percent,true);
            $brands = \model\Brands::getAll();
            $output=[];
            $i = 1;
            foreach ($brands as $item){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($item->brand_name),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(

                                HtmlTags::Input(".form-control.discountValue")->Name("brand_discount[$item->brand_id]")->Value($data[$item->brand_id]?:0)->Disabled(true),
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                    "%"
                                )


                            )
                        )
                    )
                );
                $i++;
            }
            return implode("",$output);
        }

}
