<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use model\Entity\OrdersEntity;
use model\PaymentTable;

class Orders extends ControllerScheme
{
    use ApiInterface;

    const name = 'سفارشات';

    public function main()
    {
        $user = \FwAuthSystem\Main\UserObject::instance();
        if($user->getRole() == "AdminRole") {
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAll()->sortBy('order_date',true),
            ]);
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned("stock_id = '$partnerId'")->sortBy('order_date',true),

            ]);
        }
    }

    public function submitOrder()
    {
        $customer_id = $this->ApiParam('customerId');
        $address_id = $this->ApiParam('addressId');
        $order_payment_type = $this->ApiParam('orderPaymentType');
        $products_price = $this->ApiParam('productPrice');
        $send_price = 5000;
        $total_price = $send_price + $products_price;
        $discount_code = $this->ApiParam('discountCode');
        $payment_price = $this->ApiParam('paymentPrice');
        $order_products = $this->ApiParam('products');
        if ($order_payment_type==1){
            $add = \model\Orders::add([
                'customer_id'=>$customer_id,
                'address_id'=>$address_id,
                'order_payment_type'=>$order_payment_type,
                'products_price'=>$products_price,
                'send_price'=>$send_price,
                'total_price'=>$total_price,
                'discount_code'=>$discount_code,
                'payment_price'=>$payment_price,
                'payment_status'=>1,
                'order_date'=>time(),
                'order_status'=>1,
                'order_products'=>$order_products,
            ]);
            if ($add){
                $this->setIsDone();
                return "سفارش شما با موفقیت ثبت شد";
            }
        }else{
           \model\Orders::add([
               'customer_id'=>$customer_id,
               'address_id'=>$address_id,
               'order_payment_type'=>$order_payment_type,
               'products_price'=>$products_price,
               'send_price'=>$send_price,
               'total_price'=>$total_price,
               'discount_code'=>$discount_code,
               'payment_price'=>$payment_price,
               'payment_status'=>0,
               'order_date'=>strtotime('today'),
               'order_status'=>0,
               'order_products'=>$order_products,
           ]);
            $this->setIsDone();
           $payment = new \AllSatPayment();
           $payment->PaymentModel = new PaymentTable();
           $payment->UserModel(new \model\Customers(),\model\Customers::get($customer_id));
           $payment->Amount($payment_price);
           $payment->Type('order');
           return $payment->goToPayment();
        }

    }

    public function edit(?bool $csrf = true)
    {

        $orderId = $this->requestArray()['order_id'];
        $status = $this->requestArray()['order_status'];
        if($status > 0){
            /** @var OrdersEntity $order */
            $order = \model\Orders::get($orderId);
            $lastStatus = $order->order_status;
            if ($lastStatus != $status){
                \model\Orders::edit($orderId, [
                    'order_status' => $status
                ]);
                if ($lastStatus==4 and $status != 4){
                    // پذیرش مجدد سفارش
                    $paymentType = $order->order_payment_type;
                    $paymentStatus = $order->payment_status;
                    $customerId = $order->customer_id;
                    if ($paymentType > 1 and $paymentType < 5 and $paymentStatus == 1){
                        // پرداخت انجام شده است و خرید اقساطی یا هدیه نبوده
                        $totalPay = $order->payment_price;
                        $customer = \model\Customers::get($customerId);
                        $customerCredit = $customer->customer_credit;
                        $update = \model\Customers::edit($customerId, [
                            'customer_credit' => $customerCredit - $totalPay,
                        ]);
                        if($update){
                            $description = "کاهش موجودی بایت فاکتور شماره ".$orderId;
                            creditDetails($customerId, 2, $totalPay,$customerCredit, $description);
                        }

                    }
                    $products = json_decode($order->order_products);
                    foreach ($products as $id=>$qty){
                        $mainStock = \model\MainStocks::getOneFiltered('product_id', $id);
                        $stock = \model\MainStocks::get($mainStock->main_stock_id);
                        \model\mainStockReports::add([
                                'main_stock_id' => $stock->main_stock_id,
                                'product_id' =>$stock->product_id,
                                'product_count_before' => $stock->product_count,
                                'product_count' => $qty,
                                'peyvast_code' =>$stock->peyvast_code,
                                'sell_price_before' =>$stock->sell_price,
                                'sell_price_after' =>$stock->sell_price,
                                'customer_id' => $order->customer_id,
                                'order_id' => $orderId,
                                'transfer_type' => 2
                            ]
                        );
                        \model\MainStocks::edit($mainStock->main_stock_id, [
                            'product_count' => $mainStock->product_count - $qty,
                        ]);
                    }
                }
                if ($status == 4){
                    // لغو سفارش
                    $paymentType = $order->order_payment_type;
                    $paymentStatus = $order->payment_status;
                    $customerId = $order->customer_id;
                    if ($paymentType > 1 and $paymentType < 5 and $paymentStatus == 1){
                        // پرداخت انجام شده است و خرید اقساطی یا هدیه نبوده
                        $totalPay = $order->payment_price;
                        $customer = \model\Customers::get($customerId);
                        $customerCredit = $customer->customer_credit;
                        $update = \model\Customers::edit($customerId, [
                            'customer_credit' => $customerCredit + $totalPay,
                        ]);
                        if($update){
                            $description = "افزایش موجودی بایت لغو فاکتور شماره ".$orderId;
                            creditDetails($customerId, 1, $totalPay, $customerCredit, $description);
                        }

                    }
                    $products = json_decode($order->order_products);
                    foreach ($products as $id=>$qty){
                        $mainStock = \model\MainStocks::getOneFiltered('product_id', $id);
                        $stock = \model\MainStocks::get($mainStock->main_stock_id);
                        \model\mainStockReports::add([
                                'main_stock_id' => $stock->main_stock_id,
                                'product_id' =>$stock->product_id,
                                'product_count_before' => $stock->product_count,
                                'product_count' => $qty,
                                'peyvast_code' =>$stock->peyvast_code,
                                'sell_price_before' =>$stock->sell_price,
                                'sell_price_after' =>$stock->sell_price,
                                'customer_id' => $order->customer_id,
                                'order_id' => $orderId,
                                'transfer_type' => 1,
                                'log_date' => time()
                            ]
                        );
                        \model\MainStocks::edit($mainStock->main_stock_id, [
                            'product_count' => $mainStock->product_count + $qty,
                        ]);
                    }
                }
                return showSuccessMsg('سفارش','تغییر وضعیت');
            }
            else {
                return showErrorMsg('سفارش','تغییر وضعیت');
            }
        }
    }
    protected function add(?bool $csrf = true)
    {
        $customer_id = $this->requestArray()['customer_id'];
        $customer_address_id = $this->requestArray()['customer_address_id'];
        $order_payment_type = $this->requestArray()['order_payment_type'];
        $products_price = $this->requestArray()['products_price'];
        $send_price = $this->requestArray()['send_price'];
        $total_price = $this->requestArray()['total_price'];
        $payment_price = $this->requestArray()['total_price'];
        $payment_status = 1;
        $order_date = time();
        $order_status = 1;
        $products = json_encode($this->requestArray()['products'],JSON_UNESCAPED_UNICODE);
        $user_id = UserObject::instance()->getUserId();

        $add = \model\Orders::add([
           'customer_id'=>$customer_id,
           'address_id'=>$customer_address_id,
           'order_payment_type'=>$order_payment_type,
           'user_id'=>$user_id,
           'products_price'=>$products_price,
           'send_price'=>$send_price,
           'total_price'=>$total_price,
           'payment_price'=>$payment_price,
           'payment_status'=>$payment_status,
           'order_date'=>$order_date,
           'order_status'=>$order_status,
           'order_products'=>$products
        ]);

        if ($add){
            return showSuccessMsg('سفازش','افزودن');
        }else{
            return showErrorMsg('سفازش','افزودن');
        }

    }



}
