<?php
namespace controller;
use ControllerScheme;
use FwAuthSystem\Main\UserObject;

class addOrder extends ControllerScheme {
    const name = 'addOrder';

    public function main()
    {
        return $this->view($this->viewName(), 'addIndex', []);
    }

    protected function add(?bool $csrf = true)
    {
        $customer_id = $this->requestArray()['customer_id'];
        $customer_address_id = $this->requestArray()['address_id'];
        $distribution_id = $this->requestArray()['distribution_id'];
        $order_payment_type = $this->requestArray()['payment_type'];
        $products_price = $this->requestArray()['total_price'];
        $send_price = $this->requestArray()['send_price'];
        $total_price = $this->requestArray()['total_price'];
        $payment_price = $this->requestArray()['total_price'];
        $stock_type = $this->requestArray()['stock_type'];
        $partner_id = $this->requestArray()['partner_id'];
        $discount = $this->requestArray()['discount'];
        $amountPayable = $this->requestArray()['amount_payable'];
        $payment_status = 1;
        $order_date = time();
        $order_status = 1;
        $products = array();
        foreach ($this->requestArray() as $item => $value){
            if(strstr($item, 'product_id_')) {
                $index = explode('_', $item);
                $productId = end($index);
                $productAmount = $this->requestArray()['product_count_'.$productId];
                $products[$productId] = intval($productAmount);
            }
        }
        $user_id = UserObject::instance()->getUserId();
        $cartProducts = json_encode($products);

        $add = \model\Orders::add([
            'customer_id'=>$customer_id,
            'address_id'=>$customer_address_id,
            'distribution_id'=>$distribution_id,
            'order_payment_type'=>$order_payment_type,
            'user_id'=>$user_id,
            'products_price'=>$products_price,
            'send_price'=>$send_price,
            'total_price'=>$total_price,
            'order_discount' => $discount,
            'payment_price'=>$amountPayable,
            'payment_status'=>$payment_status,
            'order_date'=>$order_date,
            'order_status'=>$order_status,
            'order_products'=>$cartProducts,
            'stock_type'=>$stock_type,
            'stock_id'=>$partner_id
        ]);

        if ($add){
            if($stock_type == 1){
                foreach ($products as $id=>$qty){
                    $mainStock = \model\MainStocks::getOneFiltered('product_id', $id);

                    $stock = \model\MainStocks::get($mainStock->main_stock_id);
                    \model\mainStockReports::add([
                            'main_stock_id' => $stock->main_stock_id,
                            'product_id' =>$stock->product_id,
                            'product_count_before' => $stock->product_count,
                            'product_count' => $qty,
                            'peyvast_code' =>$stock->peyvast_code,
                            'sell_price_before' =>$stock->sell_price,
                            'sell_price_after' =>$stock->sell_price,
                            'customer_id' => $customer_id,
                            'order_id' => $add,
                            'transfer_type' => 2,
                            'log_date' => time()
                        ]
                    );
                    \model\MainStocks::edit($mainStock->main_stock_id, [
                        'product_count' => $mainStock->product_count - $qty,
                    ]);
                }
            } elseif($stock_type == 2){
                $partner = \model\Partners::get($partner_id);
                $description = " حواله خروج از انبار نماینده ".$partner->shop_name." توسط کاربر ".UserObject::instance()->getName().' بابت فاکتور شماره '. $add;
                foreach ($products as $id=>$qty){
                    $partnerStock = \model\PartnerStocks::getOneFiltered('product_id', $id);
                    $stock = \model\PartnerStocks::get($partnerStock->partner_stock_id);
                    \model\PartnerStocksReports::add([
                            'partner_stock_id' => $stock->partner_stock_id,
                            'partner_id' =>$stock->partner_id,
                            'product_id' =>$stock->product_id,
                            'product_count_before' =>$stock->product_count,
                            'product_count_next' =>$qty,
                            'buy_price_before' =>$stock->buy_price,
                            'buy_price_next' =>$stock->buy_price,
                            'partner_price_before' =>$stock->partner_price,
                            'partner_price_next' =>$stock->partner_price,
                            'stock_type' => $stock_type,
                            'stock_id' => $partner_id,
                            'order_id' => $add,
                            'transfer_type' => 2,
                            'description' => $description,
                            'log_date' => time()
                        ]
                    );

                    \model\PartnerStocks::edit($partnerStock->partner_stock_id, [
                        'product_count' => $partnerStock->product_count - $qty,
                    ]);
                }
            } elseif($stock_type == 3){
                $partner = \model\Partners::get($partner_id);
                $description = " حواله خروج از انبار امانی نماینده ".$partner->shop_name." توسط کاربر ".UserObject::instance()->getName().' بابت فاکتور شماره '. $add;
                foreach ($products as $id=>$qty){
                    $depositeStock = \model\DepositeStocks::getOneFiltered('product_id', $id);
                    $stock = \model\DepositeStocks::get($depositeStock->deposite_stock_id);
                    \model\DepositeStocksReports::add([
                            'deposite_stock_id' => $stock->deposite_stock_id,
//                'main_stock_id' => $main_stock_id,
                            'partner_id' =>$stock->partner_id,
                            'product_id' =>$stock->product_id,
                            'product_count_before' =>$stock->product_count,
                            'product_count_next' =>$qty,
                            'buy_price_before' =>$stock->buy_price,
                            'buy_price_next' =>$stock->buy_price,
                            'partner_price_before' =>$stock->partner_price,
                            'partner_price_next' =>$stock->partner_price,
                            'settle_time_before' =>$stock->settle_time,
                            'settle_time_next' => $stock->settle_time,
                            'stock_type' => $stock_type,
                            'stock_id' => $partner_id,
                            'order_id' => $add,
                            'transfer_type' => 2,
                            'description' => $description,
                            'log_date' => time()
                        ]
                    );


                    \model\DepositeStocks::edit($depositeStock->deposite_stock_id, [
                        'product_count' => $depositeStock->product_count - $qty,
                    ]);
                }
            }

            return showSuccessMsg('سفازش','افزودن');
        }else{
            return showErrorMsg('سفازش','افزودن');
        }
    }
}