<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use fwJson\Json;
use model\Cities;
use model\Districts;
use model\Entity\CustomersEntity;
use model\Entity\StatesEntity;
use model\States;

class Customers extends ControllerScheme
{

    use ApiInterface;

    const name = 'مشتری';

    public static $__uploads = ["customer_avatar" => __SOURCE__ . "images/Customers/"];

    protected function add(?bool $csrf = true)
    {
        $mobile =  str_replace('(','',str_replace(')','',str_replace(' ','',$this->requestArray()['customer_mobile'])));
        $check = \model\Customers::getOneFiltered('customer_mobile',$mobile);
        if (!$check){
            $this->changeRequestValue('customer_status',1);
            $level_id = $this->requestArray()['customer_level_id'];
            $level = \model\Levels::get($level_id);
            if ($level->discount_percent != 0) {
                $this->changeRequestValue('set_level',1);
            }
            return parent::add($csrf); // TODO: Change the autogenerated stub
        }else{
            return '<div class="alert alert-danger  alert-dismissible mrt20">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
					<h5><i class="icon fa fa-ban"></i> ' . 'افزودن' . ' ' . 'مشتری' . ' با خطا مواجه شد!</h5>
					<p>شماره موبایل وارد شده قبلا در سیستم ثبت شده است.</p>
					<br>
				  </div>';
        }
    }

    public function getCustomerAddresses()
    {
        $customer_id = $this->requestArray()['customer_id'];
        $output=[HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
        foreach (\model\CustomerAddresses::getAllFiltered('customer_id',$customer_id) as $item){
            $output[]=HtmlTags::Option()->Value($item->customer_address_id)->Content($item->customer_address);
        }
        return implode('',$output);
    }

    public function init() {

        $mobile = str_replace(' ', '', (trim($this->ApiParam('mobile'))));

        /** @var CustomersEntity $customer */
        $customer = $this->model()::getOneFiltered('customer_mobile', $mobile);
        if ($customer and $customer->customer_status > 0) {
            if ($customer->customer_password != '') {
                $this->setIsDone();
                return Json::encode(['type' => 'login', 'has_password' => true, 'result' => true]);
            } else {
                $code = generateRandomString(4, true);
                if (sendVerify($mobile, ["$code"])) {
                    \model\Customers::edit($customer->customer_id, ['customer_code' => $code]);
                    $this->setIsDone();
                    return Json::encode([
                        'type'         => 'login',
                        'has_password' => false,
                        'result'       => true,
                        'code'         => $code,
                    ]);
                } else {
                    $this->setIsDone();
                    return Json::encode(['type' => 'login', 'has_password' => false, 'result' => false]);
                }
            }
        } else {
            $code = generateRandomString(4, true);
            if (sendVerify($mobile, ["$code"])) {
                \model\Customers::Db()->where("customer_mobile", $mobile)->delete();
                $customerData = [

                    'customer_code'       => $code,
                    'customer_mobile'     => $mobile,
                    'customer_level_id'     => 1,
                    'customer_password'     => sha1(md5($code)),
                ];
                $this->model()->add($customerData);
                $this->setIsDone();
                return Json::encode(['type' => 'register', 'result' => true]);
            } else {
                $this->setIsDone();
                return Json::encode(['type' => 'register', 'result' => false]);
            }
        }
    }

    public function startLoginRegister()
    {
        $mobile = $this->ApiParam('mobile');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            if ($id->customer_status == 1) {
                $this->setIsDone();
                return [
                    'message' => 'شماره موبایل یافت شد، لاگین کنید',
                    'status' => 1
                ];
            } else {
                $code = rand(10000, 99999);
                sendVerify($mobile, [$code]);
                \model\Customers::edit($id->customer_id, [
                    'customer_code' => $code,
                ]);
                $this->setIsDone();
                return [
                    'message' => 'کد تایید برای شما ارسال شد',
                    'status' => 0
                ];
            }
        } else {
            $code = rand(10000, 99999);
            sendVerify($mobile, [$code]);
            \model\Customers::add([
                'customer_mobile' => $mobile,
                'customer_code' => $code,
            ]);
            $this->setIsDone();
            return [
                'message' => 'کد تایید برای شما ارسال شد',
                'status' => 0
            ];
        }

    }

    public function codeValidate()
    {
        $mobile = $this->ApiParam('mobile');
        $code = $this->ApiParam('code');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            if ($code == $id->customer_code) {
                $this->setIsDone();
                return "کد صحیح است";
            } else {
                return "کد اشتباه است";
            }
        } else {
            return "شماره موبایل یافت نشد";
        }
    }

    public function setPassword()
    {
        $mobile = $this->ApiParam('mobile');
        $password = $this->ApiParam('password');

        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            \model\Customers::edit($id->customer_id, [
                'customer_password' => sha1(md5($password))
            ]);
            $this->setIsDone();
            return "password changed successfully";
        } else {
            return "customer mobile not found";
        }
    }

    public function changePassword()
    {
        $mobile = $this->ApiParam('mobile');
        $oldPassword = $this->ApiParam('oldPassword');
        $newPassword = $this->ApiParam('newPassword');

        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            if (sha1(md5($oldPassword)) == $id->customer_password) {
                \model\Customers::edit($id->customer_id, [
                    'customer_password' => sha1(md5($newPassword))
                ]);
                $this->setIsDone();
                return "password changed successfully";
            } else {
                return "old password is wrong";
            }
        } else {
            return "customer mobile not found";
        }
    }

    public function addCustomer()
    {
        $mobile =  str_replace('(','',str_replace(')','',str_replace(' ','',$this->requestArray()['mobile'])));
        $fname = $this->requestArray()['first_name'];
        $lname = $this->requestArray()['last_name'];
        $gender = $this->requestArray()['gender'];
        $password = $this->requestArray()['password'];
        $levelId = $this->requestArray()['levelId'];
        $credit = $this->requestArray()['credit'];
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
                \model\Customers::edit($id->customer_id, [
                    'customer_first_name' => $fname,
                    'customer_last_name' => $lname,
                    'customer_gender' => $gender,
                    'customer_status' => 1,
                    'customer_password' => sha1(md5($password)),
                    'customer_level_id' => $levelId,
                    'customer_credit' => $credit,

                ]);
        } else {
            \model\Customers::add([
                'customer_first_name' => $fname,
                'customer_last_name' => $lname,
                'customer_gender' => $gender,
                'customer_mobile' => $mobile,
                'customer_status' => 1,
                'customer_password' => sha1(md5($password)),
                'customer_level_id' => $levelId,
                'customer_credit' => $credit,

            ]);
        }
    }

    public function addAddress()
    {
        $customer_id = $this->requestArray()['customer_id'];
        $name = $this->requestArray()['customer_address_name'];
        $state = $this->requestArray()['state_id'];
        $city = $this->requestArray()['city_id'];
        $district = $this->requestArray()['district_id'];
        $address = $this->requestArray()['customer_address'];
        $postcode = $this->requestArray()['customer_postcode'];
        $add = \model\CustomerAddresses::add([
            'customer_id' => $customer_id,
            'customer_address_name' => $name,
            'state_id' => $state,
            'city_id' => $city,
            'district_id' => $district,
            'customer_address' => $address,
            'customer_postcode' => $postcode,

        ]);

    }

    public function getAddressByCustomerId()
    {
        $customer_id = $this->requestArray()['customer_id'];
        $outPut[]=HtmlTags::Option()->Selected()->Disabled()->Content("لطفا یک مورد را انتخاب کنید");
        foreach (\model\CustomerAddresses::getAllFiltered('customer_id',$customer_id) as $item){
            $state = States::get($item->state_id);
            $city = Cities::get($item->city_id);
            $district = Districts::get($item->district_id);
            $outPut[]=HtmlTags::Option()->Value($item->customer_address_id)->Content($state->state_name.' - '.$city->city_name.' - '.$district->district_name.' - '.$item->customer_address.' کدپستی: '.$item->customer_postcode);
        }
        return implode('',$outPut);
    }

    public function register()
    {
        $mobile = $this->ApiParam('mobile');
        $fname = $this->ApiParam('fname');
        $lname = $this->ApiParam('lname');
        $gender = $this->ApiParam('gender');
        $password = $this->ApiParam('password');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
                \model\Customers::edit($id->customer_id, [
                    'customer_first_name' => $fname,
                    'customer_last_name' => $lname,
                    'customer_gender' => $gender,
                    'customer_status' => 1,
                    'customer_password' => sha1(md5($password))
                ]);
                $this->setIsDone();
                $customer_info = \model\Customers::get($id->customer_id);
                /** @var CustomersEntity $customer_info */
                return [
                    'info' => $customer_info->apiFormat(),
                    'message' => "ثبت نام شما انجام شد"
                ];
        } else {

            return "شماره موبایل یافت نشد";
        }
    }

    public function login()
    {
        $mobile = $this->ApiParam('mobile');
        $password = $this->ApiParam('password');
        $passwordCode = $this->ApiParam('passwordCode');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            if($passwordCode == 1){
                if ($password == $id->customer_code) {
                    $this->setIsDone();
                    $customer_info = \model\Customers::get($id->customer_id);
                    /** @var CustomersEntity $customer_info */
                    return [
                        'info' => $customer_info->apiFormat(),
                        'message' => "ورود با موفقیت انجام شد"
                    ];
                } else {

                    return "رمز عبور اشتباه است";
                }
            } else {
                if (sha1(md5($password)) == $id->customer_password) {
                    $this->setIsDone();
                    $customer_info = \model\Customers::get($id->customer_id);
                    /** @var CustomersEntity $customer_info */
                    return [
                        'info' => $customer_info->apiFormat(),
                        'message' => "ورود با موفقیت انجام شد"
                    ];
                } else {

                    return "رمز عبور اشتباه است";
                }
            }
        } else {

            return "شماره موبایل یافت نشد";
        }

    }


    public function forgetPassword()
    {
        $mobile = $this->ApiParam('mobile');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            $code = rand(10000, 99999);
            sendVerify($mobile, [$code]);
            \model\Customers::edit($id->customer_id, [
                'customer_code' => $code,
            ]);
            $this->setIsDone();
            return 'کد جدید ارسال شد';
        } else {

            return "شماره موبایل یافت نشد";
        }
    }

    public function editProfile()
    {
        $fname = $this->ApiParam('fname', false);
        $lname = $this->ApiParam('lname', false);
        $gender = $this->ApiParam('gender', false);
        $avatar = $this->ApiParam('avatar', false);
        $decode = base64_decode($avatar);
        $img_name = 'customer_avatar' . time() . '.jpg';
        $mobile = $this->ApiParam('mobile');
        $stateId = $this->ApiParam('stateId', false);
        $cityId = $this->ApiParam('cityId', false);
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            file_put_contents(__SOURCE__ . "images/Customers/$img_name", $decode);
            \model\Customers::edit($id->customer_id, [
                'customer_first_name' => $fname,
                'customer_last_name' => $lname,
                'customer_gender' => $gender,
                'customer_avatar' => $img_name,
            ]);
            \model\CustomerAddresses::add([
                'customer_id' => $id->customer_id,
                'state_id' => $stateId,
                'city_id' => $cityId,
            ]);
            $this->setIsDone();
            return 'اظلاعات شما با موفقیت ثبت شد';
        } else {

            return "شماره موبایل یافت نشد";
        }


    }

    public function getCustomerInfo()
    {
        $mobile = $this->ApiParam('mobile');
        $id = \model\Customers::getOneFiltered('customer_mobile', $mobile);
        if ($id) {
            /** @var CustomersEntity $id */
            $this->setIsDone();
            return $id->apiFormat();
        } else return "شماره موبایل یافت نشد";
    }

    public function changeCustomerCredit(){
        $user = \FwAuthSystem\Main\UserObject::instance();
        $customer_id = $this->requestArray()['customerId'];
        $update_credit = intval(str_replace(',', '', $this->requestArray()['newCredit']));
        $credit_type = $this->requestArray()['creditType'];
        $customer_credit = intval(\model\Customers::get($customer_id)->customer_credit);
        $change = false;
        $newCredit = 0;
        $type =0 ;
        if($credit_type == "add"){
            $newCredit = $customer_credit + $update_credit;
            $change = true;
            $type = 1;
            $description = "افزایش موجودی بصورت دستی از پنل مدیریت توسط کاربر: ".$user->getName();
        } elseif ($credit_type == "sub") {
            $change = true;

            if($update_credit <= $customer_credit){
                $newCredit = $customer_credit - $update_credit;
                $description = "کاهش موجودی بصورت دستی از پنل مدیریت توسط کاربر: ".$user->getName();
                $type = 2;
            }
        }
        if($change){
            $update = \model\Customers::edit($customer_id, [
                'customer_credit' => $newCredit
            ]);
            if($update and $type!=0){
                creditDetails($customer_id, $type, $update_credit, $customer_credit, $description);
            }
        }
        return $customer_credit;

    }

    public function getCustomerInfoById()
    {
        $customer_id = $this->requestArray()['customerId'];
        $id = \model\Customers::get($customer_id);
        if ($id) {
            /** @var CustomersEntity $id */
            $this->setIsDone();
            return $id->customer_credit;
        } else return "مشتری یافت نشد";
    }



}
