<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class ProductInformations extends ControllerScheme
{
    use ApiInterface;

    const name = 'مشخصات فنی';




    public function getLastCategories()
    {
        $output = [HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنبد')];
        $parents=[];
        foreach (\model\Categories::getAll() as $item){
            $parents[]=$item->parent_id;
        }

        foreach (\model\Categories::getAll() as $value){
            if (in_array($value->category_id,$parents)){
                $output[]=HtmlTags::Option()->Value($value->category_id)->Content($value->category_name);
            }
        }
        return implode('',$output);
    }

    public function getCategoryInformation()
    {
        $id = $this->requestArray()['catId'];
        $result = \model\ProductInformations::getAllFiltered('category_id',$id);
        $output=[];
        $options = [];
        $i = 1 ;

        foreach ($result as $item){
            $res = \model\ProductInformationValues::getAllFiltered('product_information_value', $item->product_information_id);

              $output[]=HtmlTags::Tr()->Content(
                  HtmlTags::Td()->Content(
                      "$i"
                  ),
                  HtmlTags::Td()->Content(
                      $item->product_information_name
                  ),
                  HtmlTags::Td('.form-control')->Content(
                      HtmlTags::Select('.col-md-12')->Name("values[$item->product_information_id]")->Id($item->product_information_id)->Content(function () use ($res){
                          $options = [HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنبد')];;
                          foreach ($res as $value){
                              $options[] = HtmlTags::Option()->Value($value->product_information_value_id)->Content($value->product_information_id);
                          }
                          return $options;
                      })
//                      HtmlTags::Input()->Name("values[$item->product_information_id]")->Id($item->product_information_id)
                  )
              );
              $i++;
        }
        return implode('',$output);

    }

    public function getEditedCategoryInformation()
    {
        $product_id = $this->requestArray()['id'];
        $check = \model\ProductValues::getOneFiltered('product_id',$product_id);
        if ($check){
            $values = \model\ProductValues::getAllFiltered('product_id',$product_id);
            $valueData= [];
            $i = 1 ;
            foreach ($values as $value){
                $valueData[$i]=$value->product_value;
                $i++;
            }
        }

//        $id = $this->requestArray()['res'];
        $id = \model\Products::get($product_id)->cat_id;
        $result = \model\ProductInformations::getAllFiltered('category_id',$id);
        $output=[];
        $i = 1;
        foreach ($result as $item){
            if ($check){
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content(
                        "$i"
                    ),
                    HtmlTags::Td()->Content(
                        $item->product_information_name
                    ),
                    HtmlTags::Td('.form-control')->Content(
                        HtmlTags::Input()->Name("values[$item->product_information_id]")->Value($valueData[$i])->Id($item->product_information_id)
                    )
                );
            }else{
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content(
                        "$i"
                    ),
                    HtmlTags::Td()->Content(
                        $item->product_information_name
                    ),
                    HtmlTags::Td('.form-control')->Content(
                        HtmlTags::Input()->Name("values[$item->product_information_id]")->Id($item->product_information_id)
                    )
                );
            }

            $i++;
        }
        return implode('',$output);

    }


}


