<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\ProductsEntity;
use FwPagination\Controllers\ControllersPagination;

class Products extends ControllerScheme
{
    use ApiInterface;
    use ControllersPagination;
    const name = 'محصولات';

    public static $__uploads = ["product_image" => __SOURCE__ . "images/Products/"];

    protected function add(?bool $csrf = true)
    {
        $a = $this->requestArray();
        $cat_id = $a['cat_id'];
        $subCats = $a['sub_cats'];
        $product_name = $a['product_name'];
//        $product_price = $a['product_price'];
//        $product_amount = $a['product_amount'];
        $product_image = $_FILES['product_image'];
        $tag_ids = $a['tag_ids'];
        $brand_id = $a['brand_id'];
        $product_details = $a['product_details'];
        $product_brief = $a['product_brief'];
        $values = $a['values'];

        $add = \model\Products::add([
            'product_name'=>$product_name,
            'brand_id'=>$brand_id,
//            'product_price'=>$product_price,
//            'product_amount'=>$product_amount,
            'product_details'=>$product_details,
            'product_brief'=>$product_brief,
            'cat_id'=>$cat_id,
            'sub_cats'=>json_encode($subCats,JSON_UNESCAPED_UNICODE),
            'tag_ids'=>json_encode($tag_ids,JSON_UNESCAPED_UNICODE),
        ]);

        if ($product_image) {
            $tmpName = $_FILES['product_image']["tmp_name"];
            $imageName = "product_image" . time() . ".png";
            $folder = __SOURCE__ . "images/Products/" . $imageName;
            if (move_uploaded_file($tmpName, $folder)) {
                \model\Products::edit($add, [
                    'product_image' => $imageName
                ]);
            }
        }


        if ($values){
            $lastId= \model\Products::LastId();
            foreach ($values as $info_id=>$value){
                \model\ProductValues::add([
                    'product_information_id'=>$info_id,
                    'product_id'=>$lastId,
                    'product_value'=>$value
                ]);
            }
        }

        if ($add){
            return showSuccessMsg('محصول','افزودن');
        }else{
            return showErrorMsg('محصول','افزودن');
        }

    }

    public function edit()
    {
        $a = $this->requestArray();
        $id = $a['product_id'];
        $cat_id = $a['cat_id'];
        $subCats = json_encode($a['sub_cats'] ,JSON_UNESCAPED_UNICODE);
        if ($subCats == "null"){
            $subCats = \model\Products::get($id)->sub_cats;
        }
        $product_name = $a['product_name'];
//        $product_price = $a['product_price'];
//        $product_amount = $a['product_amount'];
        $product_image = $_FILES['product_image'];
        $tag_ids = $a['tag_ids'];
        $brand_id = $a['brand_id'];
        $product_details = $a['product_details'];
        $product_brief = $a['product_brief'];
        $values = $a['values'];
        $add = \model\Products::edit($id,[
            'product_name'=>$product_name,
            'brand_id'=>$brand_id,
//            'product_price'=>$product_price,
//            'product_amount'=>$product_amount,
            'product_details'=>$product_details,
            'product_brief'=>$product_brief,
            'cat_id'=>$cat_id,
            'sub_cats'=>$subCats,
            'tag_ids'=>json_encode($tag_ids,JSON_UNESCAPED_UNICODE),
        ]);

        if ($product_image) {
            $tmpName = $_FILES['product_image']["tmp_name"];
            $imageName = "product_image" . time() . ".png";
            $folder = __SOURCE__ . "images/Products/" . $imageName;
            if (move_uploaded_file($tmpName, $folder)) {
                \model\Products::edit($id, [
                    'product_image' => $imageName
                ]);
            }
        }
        if ($values){
            foreach (\model\ProductValues::getAllFiltered('product_id',$id) as $item){
                \model\ProductValues::delete($item->product_value_id);
            }

            foreach ($values as $info_id=>$value){
                    \model\ProductValues::add([
                        'product_information_id' => $info_id,
                        'product_id' => $id,
                        'product_value' => $value
                    ]);
                
            }
        }


        if ($add){
            return showSuccessMsg('محصول','ویرایش');
        }else{
            return showErrorMsg('محصول','ویرایش');
        }
    }

    protected function delete()
    {
        $id = $this->requestArray()['product_id'];
        foreach (\model\ProductValues::getAllFiltered('product_id',$id) as $item){
            \model\ProductValues::delete($item->product_value_id);
        }
        return parent::delete(); // TODO: Change the autogenerated stub
    }

    public function getProducts()
    {
       $result = \model\Products::getAll();
       $this->setIsDone();
       return $result->map(function (ProductsEntity $result){
           return $result->apiFormat();
       });
    }

    public function singleProduct()
    {
        $id = $this->ApiParam('id');
        $res = \model\Products::get($id);
        /** @var ProductsEntity $res */
        $this->setIsDone();
        return $res->apiFormat();
    }

    public function latestProducts()
    {
        $result = \model\Products::Db()->orderBy("product_id",true)->limit('4')->get();
        $this->setIsDone();
        return $result->map(function (ProductsEntity $p){
            return $p->apiFormat();
        });
    }

    public function getProductContent()
    {

        $id = $this->requestArray()['id'];
        $allProducts = \model\Products::getAll();
        $productOutput = [];
        foreach ($allProducts as $item){
            $decode = json_decode($item->sub_cats);
            if ($id == end($decode)){
                $productOutput[] = $item;
            }
        }

        if (!empty($productOutput)){
            $output=[];
            $i = 1;
            foreach ($productOutput as $value){
               if ($value->product_price == 0){
                   $price = "ناموجود";
                   $input =   HtmlTags::Input(".form-control.productCount")->Name("products[$value->product_id]")->Type('number')->Value('0')->Data_("id","productCount_".$value->product_id)->Data_("price",$value->product_price)->Disabled();
               }else{
                   $price = price_format($value->product_price);
                   $input =   HtmlTags::Input(".form-control.productCount")->Name("products[$value->product_id]")->Type('number')->Value('0')->Data_("id","productCount_".$value->product_id)->Data_("price",$value->product_price);
               }
                $output[]=HtmlTags::Tr()->Content(
                    HtmlTags::Td()->Content("$i"),
                    HtmlTags::Td()->Content($value->product_name."(".$price.")"),
                    HtmlTags::Td()->Content(
                        HtmlTags::Div('.input-group.mb-3.justify-content-center')->Content(
                            HtmlTags::Div('.input-group-prepend')->Content(
                              $input,
                                HtmlTags::Span('.input-group-text#basic-addon1')->Content(
                                   "عدد"
                                )
                            )
                        )
                    )
                );

                $i++;



            }
            return implode("",$output);

        }else{
            return "محصولی در این دسته بندی ثبت نشده";
        }




    }

    public function getProductsSubCats()
    {
        $id = $this->requestArray()['id'];
        $subCats = json_decode(\model\Products::get($id)->sub_cats);
        $outPut = [];
        foreach ($subCats as $item){
            $outPut[]= \model\Categories::get($item)->category_name;
        }
//        return implode('',$outPut);
        return json_encode($outPut,JSON_UNESCAPED_UNICODE);

    }

    public function getProductsLastSubCat()
    {
        $id = $this->requestArray()['id'];
        $subCats = json_decode(\model\Products::get($id)->sub_cats);
        return end($subCats);
    }
}
