<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use model\Entity\CustomersEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use PHPExcel;
use PHPExcel_IOFactory;


class InvoiceReports extends ReportScheme {

    public function exportDetailXls(){
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        /** @var OrdersEntity $order */
        /** @var CustomersEntity $customer */
        /** @var ProductsEntity $product */
        $order_id = $this->requestArray()['orderId'];
        $order = \model\Orders::get($order_id);
        $customer_id = $order->customer_id;
        $customer = \model\Customers::get($customer_id);
// Rename worksheet

        $title = "فاکتور فروش شماره " . $order_id;

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle($title)
            ->setSubject($title)
            ->setDescription($title)
            ->setKeywords("فاکتورهای فروش زمان و زیور")
            ->setCategory($title);


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'شماره فاکتور')
            ->setCellValue('B1', 'تاریخ فاکتور')
            ->setCellValue('C1', 'مشتری')
            ->setCellValue('D1', 'مبلغ کل')
            ->setCellValue('E1', 'نام انبار')
            ->setCellValue('F1', 'نحوه پرداخت')
            ->setCellValue('G1', 'وضعیت');

        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);


        if($order->order_status==1) $orderStatus = "پرداخت شده";
        elseif($order->order_status==2) $orderStatus = "ارسال شده";
        elseif($order->order_status==3) $orderStatus = "تحویل شده";
        elseif($order->order_status==4) $orderStatus = "لغو شده";
        else $orderStatus = "ناموفق";

        if($order->order_payment_type==1) $paymentType = "خرید نقدی";
        elseif($order->order_payment_type==2) $paymentType = "پرداخت آنلاین";
        elseif($order->order_payment_type==3) $paymentType = "واریز به حساب";
        elseif($order->order_payment_type==4) $paymentType = "خرید اعتباری";
        elseif($order->order_payment_type==5) $paymentType = "خرید اقساطی";
        elseif($order->order_payment_type==6) $paymentType = "هدیه";
        else $paymentType = "نامشخص";

        if($order->stock_type==1) $stockType = "انبار اصلی";
        elseif($order->stock_type==2) $stockType = "انبار نماینده";
        elseif($order->stock_type==3) $stockType = "انبار امانی";
        else $stockType = "نامشخص";

        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A2', $order->order_id)
            ->setCellValue('B2', jdate("Y/m/d H:i", ($order->order_date)))
            ->setCellValue('C2', $customer->customer_first_name.' '.$customer->customer_last_name)
            ->setCellValue('D2', number_format($order->payment_price))
            ->setCellValue('E2', $stockType)
            ->setCellValue('F2', $paymentType)
            ->setCellValue('G2', $orderStatus);


        $products = json_decode($order->order_products);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A5', 'محصولات خریداری شده');

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A6', 'ردیف')
            ->setCellValue('B6', 'نام محصول')
            ->setCellValue('C6', 'کد فنی')
            ->setCellValue('D6', 'قیمت واحد')
            ->setCellValue('E6', 'تعداد')
            ->setCellValue('F6', 'مبلغ کل');
        $i=0;
        foreach ($products as $key => $value){
            $i++;
            $product = \model\Products::get($key);
            $productCounts = \model\MainStocks::Db()->custom("select sum(product_count) as productCount, sell_price as productPrice, peyvast_code as peyvastCode from tblMainStocks where product_id = '$product->product_id'")->get()->first;
            $productCode = $productCounts->peyvastCode;
            $productPrice = $productCounts->productPrice;
            $productCounts = $productCounts->productCount;

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($i + 6), $i)
                ->setCellValue('B' . ($i + 6), $product->product_name)
                ->setCellValue('C' . ($i + 6), $productCode)
                ->setCellValue('D' . ($i + 6), number_format($productPrice))
                ->setCellValue('E' . ($i + 6), number_format($value))
                ->setCellValue('F' . ($i + 6), number_format($productPrice * $value));

            }


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__.'excel/'.$title.'.xlsx');
        return 'https://'.trim(__HOST__).'/src/excel/'.$title.'.xlsx';

    }
    public function exportXls(){
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();

        $customer_id = $this->requestArray()['customer_id'];
        $stock_type = $this->requestArray()['stock_type'];
        $payment_type = $this->requestArray()['payment_type'];
        $start_date = $this->requestArray()['date_from'];
        $end_date = $this->requestArray()['date_to'];
// Rename worksheet
        /** @var OrdersEntity $order */
        /** @var CustomersEntity $customer */
        $title = "فاکتورهای فروش";
        if($customer_id and $customer_id>0){
            $customer = \model\Customers::get($customer_id);
            $title = $title . ' '. $customer->customer_first_name.' '.$customer->customer_last_name;
        }

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle("فاکتورهای فروش")
            ->setSubject("فاکتورهای فروش")
            ->setDescription($title)
            ->setKeywords("فاکتورهای فروش زمان و زیور")
            ->setCategory("فاکتورهای فروش");


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'ردیف')
            ->setCellValue('B1', 'شماره فاکتور')
            ->setCellValue('C1', 'تاریخ فاکتور')
            ->setCellValue('D1', 'مشتری')
            ->setCellValue('E1', 'مبلغ کل')
            ->setCellValue('F1', 'نام انبار')
            ->setCellValue('G1', 'نحوه پرداخت')
            ->setCellValue('H1', 'وضعیت');



        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);







        $output = [];
        $result = \model\InvoiceReports::getReport($start_date, $end_date, $customer_id, $payment_type, $stock_type);

        $i = 0;
        foreach ($result as $order) {
            $i++;
            $customer = \model\Customers::get($order->customer_id);
            if($order->order_status==1) $orderStatus = "پرداخت شده";
            elseif($order->order_status==2) $orderStatus = "ارسال شده";
            elseif($order->order_status==3) $orderStatus = "تحویل شده";
            elseif($order->order_status==4) $orderStatus = "لغو شده";
            else $orderStatus = "ناموفق";

            if($order->order_payment_type==1) $paymentType = "خرید نقدی";
            elseif($order->order_payment_type==2) $paymentType = "پرداخت آنلاین";
            elseif($order->order_payment_type==3) $paymentType = "واریز به حساب";
            elseif($order->order_payment_type==4) $paymentType = "خرید اعتباری";
            elseif($order->order_payment_type==5) $paymentType = "خرید اقساطی";
            elseif($order->order_payment_type==6) $paymentType = "هدیه";
            else $paymentType = "نامشخص";

            if($order->stock_type==1) $stockType = "انبار اصلی";
            elseif($order->stock_type==2) $stockType = "انبار نماینده";
            elseif($order->stock_type==3) $stockType = "انبار امانی";
            else $stockType = "نامشخص";

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($i + 1), $i)
                ->setCellValue('B' . ($i + 1), $order->order_id)
                ->setCellValue('C' . ($i + 1), jdate("Y/m/d H:i", ($order->order_date)))
                ->setCellValue('D' . ($i + 1), $customer->customer_first_name.' '.$customer->customer_last_name)
                ->setCellValue('E' . ($i + 1), number_format($order->payment_price))
                ->setCellValue('F' . ($i + 1), $stockType)
                ->setCellValue('G' . ($i + 1), $paymentType)
                ->setCellValue('H' . ($i + 1), $orderStatus);

        }

        // Redirect output to a client’s web browser (Excel2007)


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__.'excel/'.time().'.xlsx');
        return 'https://'.trim(__HOST__).'/src/excel/'.time().'.xlsx';

    }

    public function getReport() {
        ob_start();
        $customer_id = $this->isSet('customer_id', function ($customer_id) {
            if (is_numeric($customer_id) and $customer_id > 0) {
                return $customer_id;
            }
            return NULL;
        });

        $payment_type = $this->isSet('payment_type', function ($payment_type) {
            if (is_numeric($payment_type)) {
                return $payment_type;
            }
            return NULL;
        });

        $stock_type = $this->isSet('stock_type', function ($stock_type) {
            if (is_numeric($stock_type)) {
                return $stock_type;
            }
            return NULL;
        });
        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == NULL) {
                return NULL;
            }
            return persianStrToTime($date_from);
        });
        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == NULL) {
                return NULL;
            }
            return persianStrToTime($date_to);
        });
        $output = [];
        $result = \model\InvoiceReports::getReport($start_date, $end_date, $customer_id, $payment_type, $stock_type);
        /** @var OrdersEntity $order */
        /** @var CustomersEntity $customer */
        foreach ($result as $order) {
            $customer = \model\Customers::get($order->customer_id);
            if($order->order_status==1) $orderStatus = "<span class='badge badge-warning'>پرداخت شده</span>";
            elseif($order->order_status==2) $orderStatus = "<span class='badge badge-info'>ارسال شده</span>";
            elseif($order->order_status==3) $orderStatus = "<span class='badge badge-success'>تحویل شده</span>";
            else $orderStatus = "<span class='badge badge-danger'>ناموفق</span>";

            if($order->order_payment_type==1) $paymentType = "<span class='badge badge-success'>خرید نقدی</span>";
            elseif($order->order_payment_type==2) $paymentType = "<span class='badge badge-success'>پرداخت آنلاین</span>";
            elseif($order->order_payment_type==3) $paymentType = "<span class='badge badge-success'>واریز به حساب</span>";
            elseif($order->order_payment_type==4) $paymentType = "<span class='badge badge-warning'>خرید اعتباری</span>";
            elseif($order->order_payment_type==5) $paymentType = "<span class='badge badge-secondary'>خرید اقساطی</span>";
            elseif($order->order_payment_type==6) $paymentType = "<span class='badge badge-secondary'>هدیه</span>";
            else $paymentType = "<span class='badge badge-danger'>نامشخص</span>";

            if($order->stock_type==1) $stockType = "<span class='badge badge-success'>انبار اصلی</span>";
            elseif($order->stock_type==2) $stockType = "<span class='badge badge-info'>انبار نماینده</span>";
            elseif($order->stock_type==3) $stockType = "<span class='badge badge-warning'>انبار امانی</span>";
            else $stockType = "<span class='badge badge-danger'>نامشخص</span>";
            $output[] = [
                'order_id' => $order->order_id,
                'CustomerName' => $customer->customer_first_name.' '.$customer->customer_last_name,
                'paymentPrice' => number_format($order->payment_price),
                'orderStatus' => $orderStatus,
                'orderDate'      => jdate("Y/m/d H:i", ($order->order_date)),
                'paymentType'        => $paymentType,
                'stockType'   => $stockType,
            ];
        }
        $InvoiceReportsReportsView = new \view\InvoiceReports($this);
        echo $InvoiceReportsReportsView->makeRow(
            $output
        );
        $content = ob_get_clean();
        return json_encode([
            'status' => true,
            'html'   => $content,
        ]);
    }

    protected function setModel(Model $model = NULL) : void {
        $this->model = new \model\Orders();
        $this->setKey($this->model->_key);
    }


}
