<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use model\Entity\CustomersEntity;
use model\Entity\mainStockReportsEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use PHPExcel;
use PHPExcel_IOFactory;


class ProductFollowReports extends ReportScheme
{

    public function exportDetailXls()
    {
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        /** @var mainStockReportsEntity $report */
        /** @var ProductsEntity $product */
        $report_id = $this->requestArray()['orderId'];
        $report = \model\mainStockReports::get($report_id);

// Rename worksheet

        $title = "گردش کالای شماره " . $report_id;

        // Set document properties
        $objPHPExcel->getProperties()
            ->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle($title)->setSubject($title)
            ->setDescription($title)
            ->setKeywords("گردش کالاها زمان و زیور")
            ->setCategory($title);


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'ردیف')
            ->setCellValue('B1', 'نوع برگه')
            ->setCellValue('C1', 'شماره برگه')
            ->setCellValue('D1', 'تاریخ برگه')
            ->setCellValue('E1', 'انبار برگه')
            ->setCellValue('F1', 'توضیحات برگه')
            ->setCellValue('G1', 'حساب مقابل برگه');

        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);

        if ($report->order_id > 0) {
            $reportStorage = "انبار اصلی";
            $againstAccount = "فاکتور فروش شماره " . $report->order_id . "";
            $reportType = "فاکتور فروش";
        } elseif ($report->transfer_type == 1 or $report->transfer_type == 2) {

            $inputStock = $report->stock_type;
            if ($inputStock == 0) {
                $reportStorage = "انبار اصلی";
                $stock = "انبار اصلی";
            } elseif ($inputStock == 3) {
                $reportStorage = "انبار ضایعات";
                $stock = "انبار ضایعات";
            } else {
                $partner = \model\Partners::get($report->stock_id);
                if ($inputStock == 1) {
                    $reportStorage = "انبار نماینده " . $partner->shop_name . "";
                    $stock = "انبار نماینده " . $partner->shop_name;
                } elseif ($inputStock == 2) {
                    $reportStorage = "انبار امانی " . $partner->shop_name . "";
                    $stock = "انبار امانی " . $partner->shop_name;
                }
            }

            if ($report->transfer_type == 1) {
                $againstAccount = "ورود کالا به " . $stock;
                $reportType = "حواله ورودی";
            } else {
                $againstAccount = "خروج کالا از " . $stock;
                $reportType = "حواله خروجی";
            }
        } else {
            $reportStorage = "انبار اصلی";
            $againstAccount = "موجودی اول دوره ";
            $reportType = "اول دوره";

        }



        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A2', 1)
            ->setCellValue('B2', $reportType)
            ->setCellValue('C2', $report->main_stock_report_id)
            ->setCellValue('D2', jdate("Y/m/d H:i", ($report->log_date)))
            ->setCellValue('E2', $reportStorage)
            ->setCellValue('F2', $report->description)
            ->setCellValue('G2', $againstAccount);





        $objPHPExcel->setActiveSheetIndex(0)->setCellValue('A5', 'اطلاعات محصول');

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A6', 'ردیف')
            ->setCellValue('B6', 'نام محصول')
            ->setCellValue('C6', 'کد فنی')
            ->setCellValue('D6', 'تعداد');
        $allProducts = \model\mainStockReports::get($report->main_stock_report_id);
        $product = \model\Products::get($allProducts->product_id);
        $productCounts = \model\MainStocks::Db()->custom("select sum(product_count) as productCount, sell_price as productPrice, peyvast_code as peyvastCode from tblMainStocks where product_id = '$product->product_id'")->get()->first;
        $productCode = $productCounts->peyvastCode;
        $productPrice = $productCounts->productPrice;
        $productCounts = $productCounts->productCount;

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A7', 1)
            ->setCellValue('B7', $product->product_name)
            ->setCellValue('C7', $productCode)
            ->setCellValue('D7', number_format($productCounts));


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__ . 'excel/' . $title . '.xlsx');
        return 'https://' . trim(__HOST__) . '/src/excel/' . $title . '.xlsx';

    }


    public function exportXls()
    {
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();

        $product_id = $this->requestArray()['product_id'];
        $start_date = $this->requestArray()['date_from'];
        $end_date = $this->requestArray()['date_to'];
// Rename worksheet
        $title = "گردش کالاها";


        // Set document properties
        $objPHPExcel->getProperties()
            ->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle("گردش کالاها")
            ->setSubject("گردش کالاها")
            ->setDescription($title)
            ->setKeywords("گردش کالاها زمان و زیور")
            ->setCategory("گردش کالاها");


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'ردیف')
            ->setCellValue('B1', 'نوع برگه')
            ->setCellValue('C1', 'شماره برگه')
            ->setCellValue('D1', 'تاریخ برگه')
            ->setCellValue('E1', 'انبار برگه')
            ->setCellValue('F1', 'توضیحات برگه')
            ->setCellValue('G1', 'حساب مقابل برگه');


        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $output = [];
        $result = \model\ProductFollowReports::getReport($start_date, $end_date, $product_id);
        /** @var mainStockReportsEntity $report */
        $i = 0;
        foreach ($result as $report) {
            $i++;
            if ($report->order_id > 0) {
                $reportStorage = "انبار اصلی";
                $againstAccount = "فاکتور فروش شماره " . $report->order_id . "";
                $reportType = "فاکتور فروش";
            } elseif ($report->transfer_type == 1 or $report->transfer_type == 2) {

                $inputStock = $report->stock_type;
                if ($inputStock == 0) {
                    $reportStorage = "انبار اصلی";
                    $stock = "انبار اصلی";
                } elseif ($inputStock == 3) {
                    $reportStorage = "انبار ضایعات";
                    $stock = "انبار ضایعات";
                } else {
                    $partner = \model\Partners::get($report->stock_id);
                    if ($inputStock == 1) {
                        $reportStorage = "انبار نماینده " . $partner->shop_name . "";
                        $stock = "انبار نماینده " . $partner->shop_name;
                    } elseif ($inputStock == 2) {
                        $reportStorage = "انبار امانی " . $partner->shop_name . "";
                        $stock = "انبار امانی " . $partner->shop_name;
                    }
                }

                if ($report->transfer_type == 1) {
                    $againstAccount = "ورود کالا به " . $stock;
                    $reportType = "حواله ورودی";
                } else {
                    $againstAccount = "خروج کالا از " . $stock;
                    $reportType = "حواله خروجی";
                }
            } else {
                $reportStorage = "انبار اصلی";
                $againstAccount = "موجودی اول دوره ";
                $reportType = "اول دوره";

            }


            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($i + 1), $i)
                ->setCellValue('B' . ($i + 1), $reportType)
                ->setCellValue('C' . ($i + 1), $report->main_stock_report_id)
                ->setCellValue('D' . ($i + 1), jdate("Y/m/d H:i", ($report->log_date)))
                ->setCellValue('E' . ($i + 1), $reportStorage)
                ->setCellValue('F' . ($i + 1), $report->description)
                ->setCellValue('G' . ($i + 1), $againstAccount);

        }

        // Redirect output to a client’s web browser (Excel2007)


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__ . 'excel/' . time() . '.xlsx');
        return 'https://' . trim(__HOST__) . '/src/excel/' . time() . '.xlsx';

    }

    public function getReport()
    {
        ob_start();

        $product_id = $this->isSet('product_id', function ($product_id) {
            if (is_numeric($product_id)) {
                return $product_id;
            }
            return NULL;
        });


        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == NULL) {
                return NULL;
            }
            return persianStrToTime($date_from);
        });
        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == NULL) {
                return NULL;
            }
            return persianStrToTime($date_to);
        });
        $output = [];
        $result = \model\ProductFollowReports::getReport($start_date, $end_date, $product_id);
        /** @var mainStockReportsEntity $report */
        foreach ($result as $report) {

            if ($report->order_id > 0) {
                $reportStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                $againstAccount = "<span class='badge badge-info'>فاکتور فروش شماره " . $report->order_id . "</span>";
                $reportType = "فاکتور فروش";
            } elseif ($report->transfer_type == 1 or $report->transfer_type == 2) {

                $inputStock = $report->stock_type;
                if ($inputStock == 0) {
                    $reportStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                    $stock = "انبار اصلی";
                } elseif ($inputStock == 3) {
                    $reportStorage = "<span class='badge badge-warning'>انبار ضایعات</span>";
                    $stock = "انبار ضایعات";
                } else {
                    $partner = \model\Partners::get($report->stock_id);
                    if ($inputStock == 1) {
                        $reportStorage = "<span class='badge badge-info'>انبار نماینده " . $partner->shop_name . "</span>";
                        $stock = "انبار نماینده " . $partner->shop_name;
                    } elseif ($inputStock == 2) {
                        $reportStorage = "<span class='badge badge-warning'>انبار امانی " . $partner->shop_name . "</span>";
                        $stock = "انبار امانی " . $partner->shop_name;
                    }
                }

                if ($report->transfer_type == 1) {
                    $againstAccount = "ورود کالا به " . $stock;
                    $reportType = "حواله ورودی";
                } else {
                    $againstAccount = "خروج کالا از " . $stock;
                    $reportType = "حواله خروجی";
                }
            } else {
                $reportStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                $againstAccount = "<span class='badge badge-info'>موجودی اول دوره </span>";
                $reportType = "اول دوره";

            }


            $output[] = [
                'report_type' => $reportType,
                'report_id' => $report->main_stock_report_id,
                'reportDate' => jdate("Y/m/d H:i", ($report->log_date)),
                'reportStorage' => $reportStorage,
                'description' => $report->description ? $report->description : "-----",
                'againstAccount' => $againstAccount,

            ];
        }
        $ProductFollowReportsReportsView = new \view\ProductFollowReports($this);
        echo $ProductFollowReportsReportsView->makeRow($output);
        $content = ob_get_clean();
        return json_encode(['status' => true, 'html' => $content,]);
    }

    protected function setModel(Model $model = NULL): void
    {
        $this->model = new \model\mainStockReports();
        $this->setKey($this->model->_key);
    }


}
