<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use model\Entity\CustomersEntity;
use model\Entity\mainStockReportsEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use PHPExcel;
use PHPExcel_IOFactory;


class TransferReports extends ReportScheme {

    public function exportDetailXls(){
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        /** @var mainStockReportsEntity $report */
        /** @var ProductsEntity $product */
        $report_id = $this->requestArray()['orderId'];
        $report = \model\mainStockReports::get($report_id);

// Rename worksheet

        $title = "حواله انبار شماره " . $report_id;

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle($title)
            ->setSubject($title)
            ->setDescription($title)
            ->setKeywords("حواله های انبار زمان و زیور")
            ->setCategory($title);


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'شماره برگه')
            ->setCellValue('B1', 'تاریخ برگه')
            ->setCellValue('C1', 'انبار مبدا')
            ->setCellValue('D1', 'انبار مقصد')
            ->setCellValue('E1', 'توضیحات');

        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);

        if($report->transfer_type == 1){
            $outputStorage = "انبار اصلی";
            $inputStock = $report->stock_type;
            if($inputStock==0) {
                $inputStorage = "انبار اصلی";
            }
            elseif($inputStock==3) {
                $inputStorage = "انبار ضایعات";
            }
            else {
                $partner = \model\Partners::get($report->stock_id);
                if($inputStock==1) $inputStorage = "انبار نماینده ".$partner->shop_name;
                elseif($inputStock==2) $inputStorage = "انبار امانی ".$partner->shop_name;
            }
        } else {
            $inputStorage = "انبار اصلی";
            $outputStock = $report->stock_type;
            if($outputStock==0) {
                $outputStorage = "انبار اصلی";
            }
            elseif($outputStock==3) {
                $outputStorage = "انبار ضایعات";
            }
            else {
                $partner = \model\Partners::get($report->stock_id);
                if($outputStock==1) $outputStorage = "انبار نماینده ".$partner->shop_name;
                elseif($outputStock==2) $outputStorage = "انبار امانی ".$partner->shop_name;
            }

        }




        $objPHPExcel->setActiveSheetIndex(0);

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A2', $report_id)
            ->setCellValue('B2', jdate("Y/m/d H:i", ($report->log_date)))
            ->setCellValue('C2', $inputStorage)
            ->setCellValue('D2', $outputStorage)
            ->setCellValue('E2', $report->description);


        $allProducts = \model\mainStockReports::getAllFiltered('main_stock_id', $report->stock_id);
        $products =array();
        foreach ($allProducts as $item){
            $products[$item->product_id] = $item->product_count;
        }

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A5', 'محصولات منتقل شده');

        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A6', 'ردیف')
            ->setCellValue('B6', 'نام محصول')
            ->setCellValue('C6', 'کد فنی')
            ->setCellValue('D6', 'تعداد');
        $i=0;
        foreach ($products as $key => $value){
            $i++;
            $product = \model\Products::get($key);
            $productCounts = \model\MainStocks::Db()->custom("select sum(product_count) as productCount, sell_price as productPrice, peyvast_code as peyvastCode from tblMainStocks where product_id = '$product->product_id'")->get()->first;
            $productCode = $productCounts->peyvastCode;
            $productPrice = $productCounts->productPrice;
            $productCounts = $productCounts->productCount;

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($i + 6), $i)
                ->setCellValue('B' . ($i + 6), $product->product_name)
                ->setCellValue('C' . ($i + 6), $productCode)
                ->setCellValue('D' . ($i + 6), number_format($productCounts));

            }


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__.'excel/'.$title.'.xlsx');
        return 'https://'.trim(__HOST__).'/src/excel/'.$title.'.xlsx';

    }


    public function exportXls(){
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();

        $inputStock = $this->requestArray()['inputStock'];
        $outputStock = $this->requestArray()['outputStock'];
        $start_date = $this->requestArray()['date_from'];
        $end_date = $this->requestArray()['date_to'];
// Rename worksheet
        $title = "حواله های انبار";


        // Set document properties
        $objPHPExcel->getProperties()->setCreator("زمان و زیور")
            ->setLastModifiedBy("زمان و زیور")
            ->setTitle("حواله های انبار")
            ->setSubject("حواله های انبار")
            ->setDescription($title)
            ->setKeywords("حواله های انبار زمان و زیور")
            ->setCategory("حواله های انبار");


// Add some data
        $objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'ردیف')
            ->setCellValue('B1', 'شماره برگه')
            ->setCellValue('C1', 'تاریخ برگه')
            ->setCellValue('D1', 'انبار مبدا')
            ->setCellValue('E1', 'انبار مقصد')
            ->setCellValue('F1', 'توضیحات');



        $objPHPExcel->getActiveSheet()->setTitle($title);
        $objPHPExcel->getActiveSheet()->setRightToLeft(true);


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        $output = [];
        $result = \model\TransferReports::getReport($start_date, $end_date, $inputStock, $outputStock);
        /** @var mainStockReportsEntity $report */
        $i = 0;
        foreach ($result as $report) {
            $i++;
            if($report->transfer_type == 1){
                $outputStorage = "انبار اصلی";
                $inputStock = $report->stock_type;
                if($inputStock==0) {
                    $inputStorage = "انبار اصلی";
                }
                elseif($inputStock==3) {
                    $inputStorage = "انبار ضایعات";
                }
                else {
                    $partner = \model\Partners::get($report->stock_id);
                    if($inputStock==1) $inputStorage = "انبار نماینده ".$partner->shop_name;
                    elseif($inputStock==2) $inputStorage = "انبار امانی ".$partner->shop_name;
                }
            } else {
                $inputStorage = "انبار اصلی";
                $outputStock = $report->stock_type;
                if($outputStock==0) {
                    $outputStorage = "انبار اصلی";
                }
                elseif($outputStock==3) {
                    $outputStorage = "انبار ضایعات";
                }
                else {
                    $partner = \model\Partners::get($report->stock_id);
                    if($outputStock==1) $outputStorage = "انبار نماینده ".$partner->shop_name;
                    elseif($outputStock==2) $outputStorage = "انبار امانی ".$partner->shop_name;
                }

            }

            $objPHPExcel->setActiveSheetIndex(0)
                ->setCellValue('A' . ($i + 1), $i)
                ->setCellValue('B' . ($i + 1), $report->main_stock_report_id)
                ->setCellValue('C' . ($i + 1), jdate("Y/m/d H:i", ($report->log_date)))
                ->setCellValue('D' . ($i + 1), $inputStorage)
                ->setCellValue('E' . ($i + 1), $outputStorage)
                ->setCellValue('F' . ($i + 1), $report->description);

        }

        // Redirect output to a client’s web browser (Excel2007)


        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(__SOURCE__.'excel/'.time().'.xlsx');
        return 'https://'.trim(__HOST__).'/src/excel/'.time().'.xlsx';

    }

    public function getReport() {
        ob_start();

        $inputStock = $this->isSet('inputStock', function ($inputStock) {
            if (is_numeric($inputStock)) {
                return $inputStock;
            }
            return NULL;
        });

        $outputStock = $this->isSet('outputStock', function ($outputStock) {
            if (is_numeric($outputStock)) {
                return $outputStock;
            }
            return NULL;
        });
        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == NULL) {
                return NULL;
            }
            return persianStrToTime($date_from);
        });
        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == NULL) {
                return NULL;
            }
            return persianStrToTime($date_to);
        });
        $output = [];
        $result = \model\TransferReports::getReport($start_date, $end_date, $inputStock, $outputStock);
        /** @var mainStockReportsEntity $report */
        foreach ($result as $report) {

            if($report->transfer_type == 1){
                $outputStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                $inputStock = $report->stock_type;
                if($inputStock==0) {
                    $inputStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                }
                elseif($inputStock==3) {
                    $inputStorage = "<span class='badge badge-warning'>انبار ضایعات</span>";
                }
                else {
                    $partner = \model\Partners::get($report->stock_id);
                    if($inputStock==1) $inputStorage = "<span class='badge badge-info'>انبار نماینده ".$partner->shop_name."</span>";
                    elseif($inputStock==2) $inputStorage = "<span class='badge badge-warning'>انبار امانی ".$partner->shop_name."</span>";
                }
            } elseif($report->transfer_type == 2) {
                $inputStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                    $outputStock = $report->stock_type;
                    if($outputStock==0) {
                        $outputStorage = "<span class='badge badge-success'>انبار اصلی</span>";
                    }
                    elseif($outputStock==3) {
                        $outputStorage = "<span class='badge badge-warning'>انبار ضایعات</span>";
                    }
                    else {
                        $partner = \model\Partners::get($report->stock_id);
                        if($outputStock==1) $outputStorage = "<span class='badge badge-info'>انبار نماینده ".$partner->shop_name."</span>";
                        elseif($outputStock==2) $outputStorage = "<span class='badge badge-warning'>انبار امانی ".$partner->shop_name."</span>";
                    }

            }else{
                continue;
            }


            $output[] = [
                'myRep' => $report->main_stock_report_id,
                'report_id' => $report->main_stock_report_id,
                'reportDate'      => jdate("Y/m/d H:i", ($report->log_date)),
                'inputStorage' => $inputStorage,
                'outputStorage' => $outputStorage,
                'description' => $report->description ? $report->description : "-----",

            ];
        }
        $TransferReportsReportsView = new \view\TransferReports($this);
        echo $TransferReportsReportsView->makeRow(
            $output
        );
        $content = ob_get_clean();
        return json_encode([
            'status' => true,
            'html'   => $content,
        ]);
    }

    protected function setModel(Model $model = NULL) : void {
        $this->model = new \model\mainStockReports();
        $this->setKey($this->model->_key);
    }


}
