<?php
namespace controller;
use ControllerScheme;
use FwConnection;

class DepositeStocks extends ControllerScheme {
    const name = 'DepositeStocks';

    public function main()
    {
        $user = \FwAuthSystem\Main\UserObject::instance();
        if($user->getRole() == "AdminRole") {
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAll(),
            ]);
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned("partner_id = '$partnerId'"),

            ]);
        }
    }

    public function mainStockLogs($main_stock_id, $product_count, $partner_price, $stock_type = 2, $stock_id, $transfer_type = 2, $description){
        $stock = \model\MainStocks::get($main_stock_id);
        \model\mainStockReports::add([
                'main_stock_id' => $stock->main_stock_id,
                'product_id' =>$stock->product_id,
                'product_count_before' => $stock->product_count,
                'product_count' => $product_count,
                'peyvast_code' =>$stock->peyvast_code,
                'sell_price_before' => $partner_price,
                'sell_price_after' => $partner_price,
                'stock_type' => $stock_type,
                'stock_id' => $stock_id,
                'transfer_type' => $transfer_type,
                'description' => $description,
                'log_date' => time()
            ]
        );
    }


    public function DepositStockLogs($partner_stock_id, $product_count, $buy_price, $partner_price, $settle_time, $stock_type = 0, $stock_id = 0, $transfer_type = 1, $description){
        $stock = \model\DepositeStocks::get($partner_stock_id);
        \model\DepositeStocksReports::add([
                'deposite_stock_id' => $stock->deposite_stock_id,
//                'main_stock_id' => $main_stock_id,
                'partner_id' =>$stock->partner_id,
                'product_id' =>$stock->product_id,
                'product_count_before' =>$stock->product_count,
                'product_count_next' =>$product_count,
                'buy_price_before' =>$stock->buy_price,
                'buy_price_next' =>$buy_price,
                'partner_price_before' =>$stock->partner_price,
                'partner_price_next' =>$partner_price,
                'settle_time_before' =>$stock->settle_time,
                'settle_time_next' => $settle_time,
                'stock_type' => $stock_type,
                'stock_id' => $stock_id,
                'transfer_type' => $transfer_type,
                'description' => $description,
                'log_date' => time()
            ]
        );
    }
    protected function delete(?bool $csrf = true)
    {
        $id = $this->requestArray()['deposite_stock_id'];
        $depositData = \model\DepositeStocks::get($id);
        $productInMainStock = \model\MainStocks::getOneFiltered('product_id', $depositData->product_id);
        $editInMainStock = \model\MainStocks::edit($productInMainStock->main_stock_id, [
            'product_count' => $productInMainStock->product_count + $depositData->product_count
        ]);
        $user = \FwAuthSystem\Main\UserObject::instance();
        $partner = \model\Partners::get($depositData->partner_id);
        $description = "حذف حواله شماره ".$id." از انبار امانی نماینده ".$partner->shop_name." توسط کاربر ".$user->getName().' و انتقال به انبار اصلی';
        $this->DepositStockLogs($id,  $depositData->product_count,  $depositData->partner_id,  $depositData->partner_price, 0, 0, 0, 2, $description);
        $this->mainStockLogs($productInMainStock->main_stock_id, $depositData->product_count, $depositData->partner_price, 2, $depositData->partner_id, 1, $description);
        return parent::delete(); // TODO: Change the autogenerated stub
    }

    protected function add(?bool $csrf = true)
    {
        $product_id = $this->requestArray()['product_id'];
        $partner_id = $this->requestArray()['partner_id'];
        $product_count = $this->requestArray()['product_count'];
        $peyvast_code = $this->requestArray()['peyvast_code'];
        $buy_price = $this->requestArray()['buy_price'];
        $partner_price = $this->requestArray()['partner_price'];
        $settle_time = $this->requestArray()['settle_time'];

        $productInMainStock = \model\MainStocks::getOneFiltered('product_id', $product_id);
        $productInPartnerStock = \model\DepositeStocks::getOneFiltered('product_id', $product_id);
        $user = \FwAuthSystem\Main\UserObject::instance();
        $partner = \model\Partners::get($partner_id);
        $description = "افزودن حواله به انبار امانی نماینده ".$partner->shop_name." توسط کاربر ".$user->getName().' و انتقال از انبار اصلی';
        if($productInMainStock and $productInMainStock->product_count >=$product_count){

            $editInMainStock = \model\MainStocks::edit($productInMainStock->main_stock_id, [
                'product_count' => $productInMainStock->product_count - $product_count
            ]);

            if($productInPartnerStock){
                $this->DepositStockLogs($productInPartnerStock->deposite_stock_id, $product_count, $buy_price, $partner_price, $settle_time, 0, 0, 1, $description);
                $addToPartnetStock = \model\DepositeStocks::edit($productInPartnerStock->deposite_stock_id, [
                    'product_count' => $productInPartnerStock->product_count + $product_count,
                    'peyvast_code'=>$peyvast_code,
                    'buy_price'=>$buy_price,
                    'partner_price'=>$partner_price,
                    'settle_time'=>$settle_time,
                ]);
            } else {
                $addToPartnetStock = \model\DepositeStocks::add([
                    'main_stock_id' => $productInMainStock->main_stock_id,
                    'partner_id'=>$partner_id,
                    'product_id'=>$product_id,
                    'product_count'=>$product_count,
                    'peyvast_code'=>$peyvast_code,
                    'buy_price'=>$buy_price,
                    'partner_price'=>$partner_price,
                    'settle_time'=>$settle_time,
                ]);
                $this->DepositStockLogs($addToPartnetStock, $product_count, $buy_price, $partner_price, $settle_time, 0, 0, 1, $description);
            }
            $this->mainStockLogs($productInMainStock->main_stock_id, $product_count, $partner_price, 2, $partner_id, 2, $description);
            if ($addToPartnetStock){

                return showSuccessMsg('کالا','افزودن');
            }else{
                return showErrorMsg('کالا','افزودن');
            }

        }



    }
    public  function getProductInformation() {
        $productId = $this->requestArray()['productId'];
        $stockType = $this->requestArray()['stockType'];
        $partnerId = $this->requestArray()['partnerId'];
        $a = array();

        $this->setIsDone();
        $output = [];
        if($stockType == 1){
            $stock = \model\MainStocks::getOneFiltered('product_id', $productId);
            $product = \model\Products::get($productId);
            $output['product_price'] = $stock->sell_price;
            $output['product_count'] = $stock->product_count;
            $output['peyvast_code'] = $stock->peyvast_code;
            $output['product_name'] = $product->product_name;
        } elseif($stockType == 2){
            $stock = \model\MainStocks::getOneFiltered('product_id', $productId);
            $partnerStock = \model\PartnerStocks::getAllConditioned("product_id = '$productId' and partner_id = '$partnerId'" )->first();
            $product = \model\Products::get($productId);
            $output['product_price'] = $partnerStock->buy_price;
            $output['product_count'] = $partnerStock->product_count;
            $output['peyvast_code'] = $stock->peyvast_code;
            $output['product_name'] = $product->product_name;
        } elseif($stockType == 3){
            $stock = \model\MainStocks::getOneFiltered('product_id', $productId);
            $depositeStock = \model\DepositeStocks::getAllConditioned("product_id = '$productId' and partner_id = '$partnerId'" )->first();
            $product = \model\Products::get($productId);
            $output['product_price'] = $depositeStock->buy_price;
            $output['product_count'] = $depositeStock->product_count;
            $output['peyvast_code'] = $stock->peyvast_code;
            $output['product_name'] = $product->product_name;
        }

        $a[]=$output;
        return json_encode($output);
    }


    public  function getProductsInfStock() {
        $partner_id = $this->requestArray()['partnerId'];
        $stokType = $this->requestArray()['stockType'];
        $stockName ='';
        $productData = '<option value="" selected disabled>لطفا یک کالا را انتخاب کنید</option>';
        if($stokType == 1){
            $products = \model\MainStocks::getAllConditioned('product_count > 0');
            $stockName = "انبار اصلی";
        } elseif($stokType == 2){
            $products = \model\PartnerStocks::getAllConditioned('partner_id = '.$partner_id.' and product_count > 0');
            $stockName = "انبار نماینده";
        } elseif($stokType == 3){
            $products = \model\DepositeStocks::getAllConditioned('partner_id = '.$partner_id.' and product_count > 0');
            $stockName = "انبار امانی نماینده";
        }

        foreach ($products as $product){
            $data = \model\Products::get($product->product_id);
            $productData .= '<option value="'.$data->product_id.'">'.$data->product_name.' --- موجودی در ' . $stockName . ':  '. $product->product_count.  ' عدد</option>';

        }
        return ($productData);
    }
}