<?php
namespace controller;
use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use FwPagination\Controllers\ControllersPagination;
use PHPExcel_IOFactory;

class MainStocks extends ControllerScheme {
    use ControllersPagination;
    const name = 'MainStocks';
    public function upload()
    {
        return $this->view($this->viewName(), 'upload', [

        ]);
    }
    public function mainStockLogs($main_stock_id, $product_count, $buy_price, $sell_price, $exist, $transfer_type = 1){
        $stock = \model\MainStocks::get($main_stock_id);
        \model\mainStockReports::add([
                'main_stock_id' => $stock->main_stock_id,
                'product_id' =>$stock->product_id,
                'product_count_before' => $exist ? $stock->product_count : 0,
                'product_count' => $product_count,
                'peyvast_code' =>$stock->peyvast_code,
                'buy_price_before' =>$stock->buy_price,
                'buy_price_after' =>$buy_price,
                'sell_price_before' =>$stock->sell_price,
                'sell_price_after' =>$sell_price,
                'transfer_type' => $transfer_type,
                'log_date' => time()
            ]
        );
    }
    public function importFile()
    {
        $stockId = ($this->requestArray()['stockId']);
        include __SOURCE__ . 'dist' . DIRECTORY_SEPARATOR . 'php' . DIRECTORY_SEPARATOR . 'ExcelReader/Classes/PHPExcel/IOFactory.php';
        $fileName = $this->requestArray()['xlsxFile'];
        $tmpName = $_FILES['xlsxFile']["tmp_name"];
        $inputFileType = 'Excel2007';
        $inputFileName = $_FILES['xlsxFile']['name'];
        $location = __SOURCE__ . "files/stocks/".$inputFileName;
        if ( move_uploaded_file($_FILES['xlsxFile']['tmp_name'], $location) ) {

            $objReader = PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($location);
            $customPropertyList = $objPHPExcel->getProperties()->getCustomProperties();
            $sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
            $i=0;
            $totalRows = count($sheetData) - 1;
            foreach($sheetData as $data){
                $i++;
                if($i == 1) continue;
                $siteId = $data["D"];
                $price = intval(str_replace(',', '',$data["F"])) / 10;
                $amount = $data["E"];
                if ($siteId){
                    $product = \model\Products::getOneFiltered('site_id', $siteId);
                    if($product){
                        $productId = $product->product_id;
                        $inStock = \model\MainStocks::getOneFiltered('product_id', $productId);
                        if($inStock){
                            $this->mainStockLogs($inStock->main_stock_id, $amount, 0, $price, true,0);
                            $add = \model\MainStocks::edit($inStock->main_stock_id, [
                                'product_id'=>$productId,
                                'product_count'=>$amount,
                                'peyvast_code'=>$siteId,
                                'sell_price'=>$price,
                            ]);
                        } else {
                            $add = \model\MainStocks::add([
                                'product_id'=>$productId,
                                'product_count'=>$amount,
                                'peyvast_code'=>$siteId,
                                'sell_price'=>$price,
                            ]);
                            $this->mainStockLogs($add, $amount, 0, $price, false, 0);
                        }

                    }
                }
                $progress = round(($i / $totalRows) * 100);
//                echo "data: {$progress}\n\n";
//                flush();
//                ob_flush();
//                usleep(10000);

            }
//            echo "data: 100\n\n"; // ارسال 100 به عنوان پیشرفت نهایی
//            flush();
//            ob_flush();
            if ($add){
                return showSuccessMsg('کالا','افزودن');
            }else{
                return showErrorMsg('کالا','افزودن');
            }
        } else {
            return showErrorMsg('کالا','افزودن');
        }


    }
    protected function add(?bool $csrf = true)
    {
        $product_id = $this->requestArray()['product_id'];
        $product_count = $this->requestArray()['product_count'];
        $peyvast_code = $this->requestArray()['peyvast_code'];
        $buy_price = $this->requestArray()['buy_price'];
        $sell_price = $this->requestArray()['sell_price'];

        $product = \model\MainStocks::getOneFiltered('product_id', $product_id);
        if($product){
            $this->mainStockLogs($product->main_stock_id, $product_count, $buy_price, $sell_price, true);
            $add = \model\MainStocks::edit($product->main_stock_id, [
                'product_count' => $product->product_count + $product_count,
                'buy_price'=>$buy_price,
                'sell_price'=>$sell_price,
                'peyvast_code'=>$peyvast_code,
            ]);

        } else {
            $add = \model\MainStocks::add([
                'product_id'=>$product_id,
                'product_count'=>$product_count,
                'peyvast_code'=>$peyvast_code,
                'buy_price'=>$buy_price,
                'sell_price'=>$sell_price,
            ]);
            $this->mainStockLogs($add, $product_count, $buy_price, $sell_price, false);
        }


        if ($add){
            return showSuccessMsg('کالا','افزودن');
        }else{
            return showErrorMsg('کالا','افزودن');
        }

    }
}