<?php
namespace controller;
use ControllerScheme;
class PartnerStocks extends ControllerScheme {
    const name = 'PartnerStocks';
    public function main()
    {
        $user = \FwAuthSystem\Main\UserObject::instance();
        if($user->getRole() == "AdminRole") {
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAll(),
            ]);
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned("partner_id = '$partnerId'"),

            ]);
        }
    }


    public function mainStockLogs($main_stock_id, $product_count, $partner_price, $stock_type = 2, $stock_id, $transfer_type = 2, $description){
        $stock = \model\MainStocks::get($main_stock_id);
        \model\mainStockReports::add([
                'main_stock_id' => $stock->main_stock_id,
                'product_id' =>$stock->product_id,
                'product_count_before' => $stock->product_count,
                'product_count' => $product_count,
                'peyvast_code' =>$stock->peyvast_code,
                'sell_price_before' => $partner_price,
                'sell_price_after' => $partner_price,
                'stock_type' => $stock_type,
                'stock_id' => $stock_id,
                'transfer_type' => $transfer_type,
                'description' => $description,
                'log_date' => time()
            ]
        );
    }

    public function PartnetStockLogs($partner_stock_id, $product_count, $buy_price, $partner_price, $stock_type = 0, $stock_id = 0, $transfer_type = 1, $description){
        $stock = \model\PartnerStocks::get($partner_stock_id);
        \model\PartnerStocksReports::add([
                'partner_stock_id' => $stock->partner_stock_id,
                'partner_id' =>$stock->partner_id,
                'product_id' =>$stock->product_id,
                'product_count_before' =>$stock->product_count,
                'product_count_next' =>$product_count,
                'buy_price_before' =>$stock->buy_price,
                'buy_price_next' =>$buy_price,
                'partner_price_before' =>$stock->partner_price,
                'partner_price_next' =>$partner_price,
                'stock_type' => $stock_type,
                'stock_id' => $stock_id,
                'transfer_type' => $transfer_type,
                'description' => $description,
                'log_date' => time()
            ]
        );
    }

    protected function delete(?bool $csrf = true)
    {
        $id = $this->requestArray()['partner_stock_id'];
        $depositData = \model\PartnerStocks::get($id);
        $productInMainStock = \model\MainStocks::getOneFiltered('product_id', $depositData->product_id);
        $editInMainStock = \model\MainStocks::edit($productInMainStock->main_stock_id, [
            'product_count' => $productInMainStock->product_count + $depositData->product_count
        ]);
        $user = \FwAuthSystem\Main\UserObject::instance();
        $partner = \model\Partners::get($depositData->partner_id);
        $description = "حذف حواله شماره ".$id." از انبار نماینده ".$partner->shop_name." توسط کاربر ".$user->getName().' و انتقال به انبار اصلی';
        $this->PartnetStockLogs($id,  $depositData->product_count,  $depositData->partner_id,  $depositData->partner_price, 0, 0, 0, $description);
        $this->mainStockLogs($productInMainStock->main_stock_id, $depositData->product_count, $depositData->partner_price, 1, $depositData->partner_id, 1, $description);
        return parent::delete(); // TODO: Change the autogenerated stub
    }

    protected function add(?bool $csrf = true)
    {
        $product_id = $this->requestArray()['product_id'];
        $partner_id = $this->requestArray()['partner_id'];
        $product_count = $this->requestArray()['product_count'];
        $peyvast_code = $this->requestArray()['peyvast_code'];
        $buy_price = $this->requestArray()['buy_price'];
        $partner_price = $this->requestArray()['partner_price'];
        $settle_time = $this->requestArray()['settle_time'];

        $productInMainStock = \model\MainStocks::getOneFiltered('product_id', $product_id);
        $productInPartnerStock = \model\PartnerStocks::getOneFiltered('product_id', $product_id);
        $user = \FwAuthSystem\Main\UserObject::instance();
        $partner = \model\Partners::get($partner_id);
        $description = "افزودن حواله به انبار نماینده ".$partner->shop_name." توسط کاربر ".$user->getName().' و انتقال از انبار اصلی';
        if($productInMainStock and $productInMainStock->product_count >=$product_count){
            $editInMainStock = \model\MainStocks::edit($productInMainStock->main_stock_id, [
                'product_count' => $productInMainStock->product_count - $product_count
            ]);

            if($productInPartnerStock){
                $this->PartnetStockLogs($productInPartnerStock->partner_stock_id, $product_count, $buy_price, $partner_price, 0, 0, 1, $description);
                $addToPartnetStock = \model\PartnerStocks::edit($productInPartnerStock->partner_stock_id, [
                    'product_count' => $productInPartnerStock->product_count + $product_count,
                    'peyvast_code'=>$peyvast_code,
                    'buy_price'=>$buy_price,
                    'partner_price'=>$partner_price,
                ]);
            } else {
                $addToPartnetStock = \model\PartnerStocks::add([
                    'partner_id'=>$partner_id,
                    'product_id'=>$product_id,
                    'product_count'=>$product_count,
                    'peyvast_code'=>$peyvast_code,
                    'buy_price'=>$buy_price,
                    'partner_price'=>$partner_price,
                ]);
                $this->PartnetStockLogs($productInPartnerStock->partner_stock_id, $product_count, $buy_price, $partner_price, 0, 0, 1, $description);
            }
            $this->mainStockLogs($productInMainStock->main_stock_id, $product_count, $partner_price, 1, $partner_id, 2, $description);
            if ($addToPartnetStock){

                return showSuccessMsg('کالا','افزودن');
            }else{
                return showErrorMsg('کالا','افزودن');
            }

        }



    }
    public  function getProductInformation() {
        $productId = $this->requestArray()['productId'];
        $a = array();
        $this->setIsDone();
        $output = [];
        $stock = \model\MainStocks::getOneFiltered('product_id', $productId);
        $product = \model\Products::get($productId);
        $output['product_price'] = $product->product_price;
        $output['product_count'] = $stock->product_count;
        $output['peyvast_code'] = $stock->peyvast_code;
        $a[]=$output;
        return json_encode($output);
    }
}