<?php
namespace controller;
use ControllerScheme;
use FwPagination\Controllers\ControllersPagination;
class DepositeStocksReports extends ControllerScheme {
    use ControllersPagination;
    const name = 'DepositeStocksReports';
    public function outStock()
    {

        $user = \FwAuthSystem\Main\UserObject::instance();
        if($user->getRole() == "AdminRole"){
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned('transfer_type = 2')->sortBy('log_date', true),

            ]);
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned("transfer_type = 2 and partner_id = '$partnerId'")->sortBy('log_date', true),

            ]);
        } else {
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned('transfer_type = 33'),

            ]);
        }

    }

    public function inStock()
    {
        $user = \FwAuthSystem\Main\UserObject::instance();
        if($user->getRole() == "AdminRole"){
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned('transfer_type = 1')->sortBy('log_date', true),

            ]);
        } elseif($user->getRole() == "PartnerRole"){
            $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
            $partnerId = $partner['partner_id'];
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned("transfer_type = 1 and partner_id = '$partnerId'")->sortBy('log_date', true),

            ]);
        } else {
            return $this->view($this->viewName(), 'main', [
                $this->model()->getAllConditioned('transfer_type = 33'),

            ]);
        }
    }
}