<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\BannersEntity;
use model\Entity\TicketsEntity;

class Tickets extends ControllerScheme
{
    use ApiInterface;

    const name = 'اسلایدر';


    public function addTicket()
    {
        $customer_id = $this->ApiParam('customerId', false);
        $customer_name = $this->ApiParam('customerName');
        $ticket = $this->ApiParam('ticket');
        $email = $this->ApiParam('email');
        $add = \model\Tickets::add([
            'ticket_name' => $customer_name,
            'customer_id' => $customer_id,
            'ticket_text' => $ticket,
            'ticket_email' => $email
        ]);
        if ($add) {
            $this->setIsDone();
            return "تیکت شما با موفقیت ثبت شد";
        } else {
            return "ثبت تیکت با خطا مواجه شد";
        }
    }

    public function MyTickets()
    {
        $customer_id = $this->ApiParam('customerId');
        $res = \model\Tickets::getAllFiltered('customer_id', $customer_id);
        $this->setIsDone();
        return $res->map(function (TicketsEntity $res) {
            return $res->apiFormat();
        });
    }

    public function answerTicket()
    {
        $ticketId = $this->requestArray()['ticketId'];
        $email = \model\Tickets::get($ticketId)->ticket_email;
        $answer = $this->requestArray()['result'];
        $email = mail($email, 'پاسخ تیکت ثبت شده در زمان و زیور', $answer);
        if ($email == true) {
            \model\Tickets::edit($ticketId, [
                'ticket_answer' => $answer
            ]);
            return "1";
        } else {
            return "2";
        }

    }

}
