<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;

class UsersTable extends ControllerScheme
{

    use ApiInterface;

    const name = 'کاربران پنل';
    public function main()
    {
        return $this->view($this->viewName(), 'main', [
            $this->model()->getAllConditioned('role_name = "adminRole" or role_name = "ConsultantRole"'),

        ]);
    }

    protected function add(?bool $csrf = true)
    {
        $a = $this->requestArray();
        $username = $a['user_username'];
        $password = sha1(md5($a['user_password']));
        $name = $a['user_name'];
        $role = $a['role_name'];
        $add =\model\UsersTable::add([
            'user_username' => $username,
            'user_password' => $password,
            'user_name' => $name,
            'role_name' => $role,
            'user_nameToKnow' => $name
        ]);
        if ($add){
            return showSuccessMsg('کاربر','اقزودن');
        }else{
            return showErrorMsg('کاربر','افزودن');
        }

    }

}
