<?php

namespace FwPagination\Controllers;
trait ControllersPagination {
    final public function fwPagination_getPaginationInfo() {
        header("Content-Type: application/json");
        $this->checkCurrentPage();
        return json_encode([
            'totalPages'  => $this->fwPagination_getTotalPageCount(),
            'currentPage' => $_SESSION[$this->class()]['pagination']['currentPage'],
            'limit'       => $_SESSION[$this->class()]['pagination']['limit'],
            'isOk'        => true,
        ]);
    }

    public function checkCurrentPage() {
        $total = $this->fwPagination_getTotalPageCount();
        if ($_SESSION[$this->class()]['pagination']['currentPage'] > $total) {
            $_SESSION[$this->class()]['pagination']['currentPage'] = $total - 2;
        }
    }

    private function fwPagination_getTotalPageCount() {
        $count = $this->model()::Db()->rowCount();
        $fields = $_SESSION[$this->class()]['pagination']['fields'];
        $query = $_SESSION[$this->class()]['pagination']['query'];
        if (is_array($fields) and count($fields) > 0 and strlen($query.'') > 0) {
            $db = $this->model()::Db();
            foreach ($fields as $field) {
                $db = $db->orWhere($field, 'like', "%$query%");
            }
            $count = $db->rowCount();
        }
        return ceil($count / $_SESSION[$this->class()]['pagination']['limit']);
    }

    final protected function fwPagination_goToNthPage() {
        $_SESSION[$this->class()]['pagination']['currentPage'] = $this->requestArray()['num'];
        $fields = $_SESSION[$this->class()]['pagination']['fields'];
        $query = $_SESSION[$this->class()]['pagination']['query'];
        return $this->main($fields, $query);
    }

    public function main($fields = [], $query = ''): string {
        $limit = $_SESSION[$this->class()]['pagination']['limit'];
        $this->model()->paginate()->changeLimit($limit ?? 10);
        if (is_array($fields) and count($fields) > 0) {
            $db = $this->model()::Db();
            foreach ($fields as $field) {
                $db = $db->orWhere($field, 'like', "%$query%");
            }
            $db = $db->limit($limit)->offset($limit * $_SESSION[$this->class()]['pagination']['currentPage'])->orderBy($this->orderBy())->get();
        } else {
            $db = $this->model()->paginate()->nthPage($_SESSION[$this->class()]['pagination']['currentPage'], $this->orderBy());
        }
        return $this->view($this->viewName(), 'main', [
            $db,
        ]);
    }

    protected function orderBy(): string {
        return $this->model()->_key;
    }

    final protected function fwPagination_changeLimit() {
        $limit = $this->requestArray()['limit'];
        $_SESSION[$this->class()]['pagination']['limit'] = $limit;
        if ($limit >= $this->model()::Db()->rowCount()) {
            $_SESSION[$this->class()]['pagination']['currentPage'] = 0;
        }
        $this->checkCurrentPage();
        return $this->main();
    }

    final protected function fwPagination_search() {
        $fields = $this->requestArray()['fields'];
        $query = $this->requestArray()['query'];
        $_SESSION[$this->class()]['pagination']['fields'] = $fields;
        $_SESSION[$this->class()]['pagination']['query'] = $query;
        return $this->main($fields, $query);
    }
}
