<?php
namespace helpers;
use DateTime;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\SendingTimesEntity;

final class DayHelper {

    static protected $arrayOfDays = [
        'Saturday' => 'شنبه',
        'Sunday' => 'یک شنبه',
        'Monday' => 'دو شنبه',
        'Tuesday' => 'سه شنبه',
        'Wednesday' => 'چهار شنبه',
        'Thursday' => 'پنج شنبه',
        'Friday' => 'جمعه'
    ];
    public static function toOption(bool $selected = true) {
        $output = [];
        foreach (self::toArray() as $key => $item){
            $output[] = HtmlTags::Option()->Value($key)->Content($item);
            if ($selected) end($output)->Selected();
        }
        return implode('',$output);
    }

    public static function toArray() {
        return self::$arrayOfDays;
    }

    public static function today() {
        return date('l');
    }
    public static function dayAfter($day = null) {
        if ($day == null){
            $day = date('l');
        }
        return date('l',strtotime("tomorrow",strtotime($day)));
    }

    public static function isShiftOkForTommorow(SendingTimesEntity $shift) {
        return in_array(self::dayAfter(),json_decode($shift->time_days,true));
    }
    public static function shiftsForToday($shifts) {
        return self::shiftsForDate($shifts,self::today());
    }
    public static function shiftsForTommorow($shifts) {
        return self::shiftsForDate($shifts,self::dayAfter());
    }

    public static function firstDayForShift(SendingTimesEntity $currentShift) {
        return 48;
    }
    public static function isShiftLeft(array $shiftForToday) {

        $hour = date("H");
        $minute = date("i");
        $output = [];
        /** @var SendingTimesEntity $shift */
        foreach ($shiftForToday as $shift){


            $startArray = explode(':',$shift->time_start);
            $startHour = $startArray[0];
            $startMinute = $startArray[1];

            $endArray = explode(':',$shift->time_end);
            $endHour = $endArray[0];
            $endMinute = $endArray[1];

            $penaltyHour = $shift->time_penalty / 60;
            if ($penaltyHour >= 1){
                $test = $hour < $startHour - $penaltyHour;
            } else {
                $test = ($hour <= $startHour) and $minute < ($startMinute + $penaltyHour * 60);
            }
            if ($test) return  true;
        }
        return false;
    }
    public static function getShiftsLeft(array $shiftForToday) {

        $hour = date("H");
        $minute = date("i");
        $output = [];
        /** @var SendingTimesEntity $shift */
        foreach ($shiftForToday as $shift){


            $startArray = explode(':',$shift->time_start);
            $startHour = $startArray[0];
            $startMinute = $startArray[1];

            $endArray = explode(':',$shift->time_end);
            $endHour = $endArray[0];
            $endMinute = $endArray[1];

            $penaltyHour = $shift->time_penalty / 60;
            if ($penaltyHour >= 1){
                $test = $hour < $startHour - $penaltyHour;
            } else {
                $test = ($hour < $startHour) or (($hour <= $startHour) and $minute < $startMinute);
            }
            if ($test){
                $output[] = $shift;
            }
        }
        return $output;
    }

    public static function UniqueShifts(array $shiftsForToday) {
        $newData = [];
        $usedTiems = [];
        /** @var SendingTimesEntity $datum */
        foreach ($shiftsForToday as $datum){
            $time = $datum->time_start.'-'.$datum->time_end;
            if (!in_array($time,$usedTiems)){
                $usedTiems[] = $time;
                $newData[] = $datum;
            }
        }
        return $newData;
    }

    public static function shiftsForDate(array $Shift, string $date) {
        $output = [];
        /** @var SendingTimesEntity $shift */
        foreach ($Shift as $shift){
            if (in_array($date,json_decode($shift->time_days,true))){
                $output[] = $shift;
            }
        }
        return $output;
    }
}
