<?php

class  FinoTechHelper {
	const baseUrl = "https://apibeta.finnotech.ir";
	const version = "2";
    public static function getTokens($scope) {
        $applicationId = "saraf24";
        $pass = "7Z5pZH7k8dQJwzIC3fIR";
        $token = base64_encode($applicationId.':'.$pass);
        $parameters = array(
            'grant_type'	=> "client_credentials",
            'nid'		    => "0061718696",
            'scopes'		=> $scope
        );

        return CallAPI("get", self::baseUrl . "/dev/v2/clients/saraf24/tokens", $parameters, [
            'Authorization' => "Basic " . $token,
        ]);
    }

    public static function makeToken($scope) {
        $applicationId = "saraf24";
        $pass = "7Z5pZH7k8dQJwzIC3fIR";
        $token = base64_encode($applicationId.':'.$pass);
        $parameters = array(
            'grant_type'	=> "client_credentials",
            'nid'		    => "0061718696",
            'scopes'		=> $scope
        );

        return CallAPI("post", self::baseUrl . "/dev/v2/oauth2/token", $parameters, [
            'Authorization' => "Basic " . $token,
        ]);
    }

    public static function cardToIban(string $cardNumber, string $trackId) {
        $scope = "facility:card-to-iban:get";
        $res = self::makeToken($scope);
        $data = json_decode($res, true);
        $token = $data['result']['value'];
        $status = $data['status'];
        return self::_request("/facility/v2/clients/saraf24/cardToIban?version=2&trackId=$trackId&card=$cardNumber", 'get', $token);
    }

    public static function ibanOwnerVerification(string $birthDate, string $NationalCode, string $iban, string $trackId) {
        $scope = "kyc:iban-owner-verification:get";
        $res = self::makeToken($scope);
        $data = json_decode($res, true);
        $token = $data['result']['value'];
        $status = $data['status'];
        return self::_request("/kyc/v2/clients/saraf24/ibanOwnerVerification?version=2&trackId=$trackId&birthDate=$birthDate&nid=$NationalCode&iban=$iban", 'get', $token);
    }

    public static function bankInfo(string $trackId) {
        $scope = "facility:cc-bank-info:get";
        $res = self::makeToken($scope);
        $data = json_decode($res, true);
        $token = $data['result']['value'];
        $status = $data['status'];
//        $token = "eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0b2tlbklkIjoiNWRlN2FjMDAtNmI0MS00MzMwLTg3MWYtNmUwYTEyNDY0YzFlIiwicmVmcmVzaFRva2VuIjoiUk5VYzU2d01RVzJMRXZUcUZTb0xTY001U1VIYVkwQmdKNVJqcWxFd0U2RnN3ZEd5cmFFdnJrdGFYajlhOWVkQ3hEbzJrdUZxOTRuTTFyN29GU2xXeUhYWFd2dVA3dWExMTJvUHFtOWJrdjJHdVkxaUoxS05UUVl4eWxrSWVMSUtxVHYyMUk3VnlxV1dwSjZjOFp1RzhReXdkMXhCcFFiSnN2YmlBZHNaN3JrOFhNbHd3OWlram91WnpXdjRzeFhVOU1oanVXV0ZTbWxZRWRicG9UcElZTVdIUzgxUFRCZ2p6TkJsQ1AxeXZubWRtODQxQmxxUlJ0TERBNThxSU9XRiIsImNyZWF0aW9uRGF0ZSI6IjE0MDIwNDI3MTA1NDI2IiwibGlmZVRpbWUiOjg2NDAwMDAwMCwiY2xpZW50SWQiOiJzYXJhZjI0IiwidXNlcklkIjoiMDA2MTcxODY5NiIsImFjdGl2ZSI6dHJ1ZSwic2NvcGVzIjpbImZhY2lsaXR5OmNjLWJhbmstaW5mbzpnZXQiXSwidHlwZSI6IkNMSUVOVC1DUkVERU5USUFMIiwiY2xpZW50SW5mbyI6IjVuWlZDb1VGdU1KeVVYMUlwRWNwa3oxTTRnUm8xaWQzSXlrQTRrSndDMmxkWEhSVkM0QkJwUlgxSEdmMVpINUNja2ZYclpNWE5yMHQ1cjc3c1NETSIsImJhbmsiOiIwNjIiLCJpYXQiOjE2ODk2NjUwNjYsImV4cCI6MTY5MDUyOTA2Nn0.QRCI34rTviOQXEZVJltRj1BGIcayDFbDZM_raTkpHKD3BLr4lQp-INpPesyvX3P_2VFr_a7qs75CbmbhsjnEx_XUGZAQjSDwNBSQkzOyFmiRizem5--9bccatf-70gFmbtA3sumtsIfvJqL_cUSTYmpwsez-peFRM2ipQv4tTMfgyKBTVLTB7rsXPC1HW7Y9vfC1oh8cmZTarF-krxBNpbu8zdZRxVnmBDBPe53dfANch4VPUCVIpcj02jJrMxnyh-NYeNuSecsZKGY5LsstQ8hLWxuWvTvu5Qlx6yCkfV1Gd0iYs66IAyuqY9sznpqomnJ4DFlV6IHqL8ot8D-VsA";
        return self::_request("/facility/v2/clients/saraf24/banksInfo?trackId=$trackId", 'get', $token);
    }

    public static function shahkarStatus(string $trackId, string $mobile, string $nationalCode) {
        $scope = "facility:shahkar:get";
        $res = self::makeToken($scope);
        $data = json_decode($res, true);
        $token = $data['result']['value'];
        $status = $data['status'];
        return self::_request("/facility/v2/clients/saraf24/shahkar/verify?trackId=$trackId&mobile=$mobile&nationalCode=$nationalCode", 'get', $token);
    }

    public static function checkNid(string $trackId, string $nationalCode, string $birthDate, string $firstName, string $lastName, string $fullName) {
        $scope = "facility:cc-nid-verification:get";
        $res = self::makeToken($scope);
        $data = json_decode($res, true);
        $token = $data['result']['value'];
        $status = $data['status'];
        return self::_request("/facility/v2/clients/saraf24/users/$nationalCode/cc/nidVerification?trackId=$trackId&birthDate=$birthDate&fullName=$fullName&firstName=$firstName&lastName=$lastName", 'get', $token);
    }

	private static function _request(string $url, string $method = 'get', string $token) {
		return CallAPI($method, self::baseUrl . $url, false, [
			'Authorization' => "Bearer " . $token,
		]);
	}
}