<?php

namespace helpers;

use FwHtml\Elements\Tags\Main\HtmlTags;

final class OrderStatus {

	static protected $arrayOfStatus = [
		'0' => [
			'name' => 'در انتظار شروع شیفت',
			'motion' => "waiting.json",
			'isActive' => false
		],
		'1' => [
			'name' => 'در حال آمادی سازی',
			'motion' => "baking.json",
			'isActive' => false,
		],
		'2' => [
			'name' => 'ارسال شد',
			'motion' => "delivery.json",
			'isActive' => false,
		],
		'3' => [
			'name' => 'تحویل داده شد',
			'motion' => "delivered.json",
			'isActive' => false,
			'ask' => [
				'title' => 'واقعا رسید؟',
				'options' => [
					'بله',
					'نه هنوز',
				],
			],
		],
	];

	public static function toOption(bool $selected = true) {
		$output = [];
		foreach (self::toArray() as $key => $item) {
			$output[] = HtmlTags::Option()->Value($key)->Content($item['name']);
		}
		return implode('', $output);
	}

	public static function toArray() {
		return self::$arrayOfStatus;
	}

	public static function toApi($current_status = 0) {
		$output = [];
		foreach (self::toArray() as $key => $item) {
			$item['id'] = $key;
			if ($key == $current_status){
				$item['isActive'] = true;
			}
			$item['motion'] = "https://" . \FwConfig::HOST() . '/src/images/OrderStatus/' . $item['motion'];
			$output[] = $item;
		}
		return $output;
	}
}
