<?php

namespace FwPagination\Views;

use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Base\TagsClass;

trait ViewPagination {

    final protected function wrap(TagsClass $tags, int $limitBase = 10, array $searchColumns = [], string $placeHolder = 'جستجو...'): array {
        $this->initDataTable = false;
        return [
            HtmlTags::Div('.card.card-warning.card-outline.w-100')->Content(
                HtmlTags::Div('.card-body.d-flex.flex-wrap.w-100')->Content(
                    HtmlTags::Div('.form-group.col-md-6')->Content(
                        HtmlTags::Select('.w-100.fwPaginationLimit')->Content(function () use ($limitBase) {
                            $output = [];
                            for ($i = $limitBase; $i <= $limitBase * 10; $i = $i + $limitBase) {
                                $output[] = HtmlTags::Option()->Value("$i")->Content("نمایش $i ستون");
                            }
                            return $output;
                        })
                    ),
                    HtmlTags::Div('.form-group.col-md-6')->Content(
                        HtmlTags::Input(".form-control.fwPaginationSearch.text-left")->Data_('fields',json_encode($searchColumns))->PlaceHolder($placeHolder)->Value($_SESSION[$this->Controller()->class()]['pagination']['query'] ?? '')
                    )
                )
            ),
            $tags,
            HtmlTags::Ul('.fwPaginationBox.pagination.mt-2.pull-left.ml-0.mr-auto')->Content(
                HtmlTags::Li('.page-item.previous.disabled')->Content(
                    HtmlTags::A('.page-link')->Href('#')->Content(
                        "Previous"
                    )
                ),
                HtmlTags::Li('.page-item.previous')->Content(
                    HtmlTags::A('.page-link')->Href('#')->Content(
                        "Next"
                    )
                )
            ),
            $this->Script("paginate"),
        ];
    }
}
