<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BannersEntity extends EntityScheme
{
    public $banner_id;
    public $banner_image;
    public $banner_title;
    public $banner_first_header;
    public $banner_second_header;
    public $banner_body;
    public $banner_link;

    public function model()
    {
        return new \model\Banners();
    }

    public function apiFormat()
    {
        return [
            'id' => $this->banner_id,
            'image' => "https://zamanzeevar.negarine.com//admin/src/images/Banners/" . $this->banner_image,
            'header'=>$this->banner_header,
            'body'=>$this->banner_body,
            'link'=>$this->banner_link
        ];
    }


    protected function dictionary(): array
    {
        return [
            'banner_id' => 'banner_id',
            'banner_image' => 'banner_image',
            'banner_title' => 'banner_title',
            'banner_first_header' => 'banner_first_header',
            'banner_second_header' => 'banner_second_header',
            'banner_body' => 'banner_body',
            'banner_link' => 'banner_link',
        ];
    }

}
