<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class CategoriesEntity extends EntityScheme {

    public $category_id;
    public $category_name;
    public $parent_id;
    public $category_icon;
    public $sort_index;


    public function model() {
        return new \model\Categories();
    }
    
    protected function dictionary() : array {
        return [
            'id'         => 'category_id',
            'name' => 'category_name',
            'parent' => 'parent_id',
            'category_icon' => 'category_icon',
            'sort_index' => 'sort_index',
        ];
    }

    public function apiFormat() {
        $hasSub=\model\Categories::getOneFiltered('parent_id',$this->category_id);
        $hasSub?$hasSub="true":$hasSub="false";
        return [
            'id'   => $this->category_id,
            'name' => $this->category_name,
            'parent' => $this->parent_id,
            'icon' => $this->category_icon,
            'sort_index' => $this->sort_index,
            'hasSub'=>$hasSub
        ];
    }

    public function toOption() : Option {
        return $this->__toOption('category_name');
    }
}
