<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class CitiesEntity extends EntityScheme {
    public $city_id;
    public $state_id;
    public $city_name;


	public function model() {
		return new \model\Cities();
	}


	public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->city_id)->Content($this->city_name);
    }

    public function apiFormat()
    {
        return[
          'stateId'=>$this->state_id,
          'stateName'=>\model\States::get($this->state_id)->state_name,
          'cityId'=>$this->city_id,
          'cityName'=>$this->city_name
        ];
    }

    protected function dictionary() : array {
		return [
			'city_id'=>'city_id',
			'state_id'=>'state_id',
			'city_name'=>'city_name',
		];
	}

}
