<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class DistrictsEntity extends EntityScheme
{
    public $district_id;
    public $state_id;
    public $city_id;
    public $district_name;


    public function model()
    {
        return new \model\Districts();
    }

    public function apiFormat()
    {
        return [
            'stateId' => $this->state_id,
            'stateName' => \model\States::get($this->state_id)->state_name,
            'cityId' => $this->city_id,
            'cityName'=>\model\Cities::get($this->city_id)->city_name,
            'districtId'=>$this->district_id,
            'districtName'=>$this->district_name
        ];
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->district_id)->Content($this->district_name);
    }

    protected function dictionary(): array
    {
        return [
            'district_id' => 'district_id',
            'state_id' => 'state_id',
            'city_id' => 'city_id',
            'district_name' => 'district_name',
        ];
    }

}
