<?php

namespace model\Entity;

use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class StatesEntity extends EntityScheme {
	public $state_id;
	public $state_name;


	public function model() {
		return new \model\States();
	}


	protected function dictionary() : array {
		return [
			'id'         => 'state_id',
			'state_name' => 'state_name',
		];
	}

	public function apiFormat() {
		return [
			'id'   => $this->state_id,
			'name' => $this->state_name,
		];
	}

	public function toOption() : Option {
		return $this->__toOption('state_name');
	}
}
