<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BlogsEntity extends EntityScheme
{
    public $blog_id;
    /**
    عنوان بلاگ
     **/
    public $title;
    /**
    دسته بندی
     **/
    public $group_id;
    /**
    برچسب ها
     **/
    public $tag_id;
    /**
    تاریخ
     **/
    public $date;
    /**
    تصویر
     **/
    public $image;
    /**
    توضیح خاص
     **/
    public $brief;
    /**
    توضیح کامل
     **/
    public $description;
    /**
    تعداد بازدید
     **/
    public $views;


    public function model()
    {
        return new \model\Blogs();
    }

    public function apiFormat()
    {
        return [
            'id' => $this->blog_id,
            'categoryId'=>$this->category_id,
            'category'=>\model\BlogCategories::get($this->category_id)->category_name,
            'title' => $this->blog_title,
            'text' => $this->blog_text,
            'image' => 'https://zamanzeevar.negarine.com/admin/src/images/Blogs/' . $this->blog_image
        ];
    }


    protected function dictionary(): array
    {
        return  [
            'blog_id' => 'blog_id',
            'title' => 'blog_title',
            'group_id' => 'blog_group_id',
            'tag_id' => 'blog_tag_id',
            'date' => 'blog_date',
            'image' => 'blog_image',
            'brief' => 'blog_brief',
            'description' => 'blog_description',
            'views' => 'blog_views',
        ];
    }

}
