<?php
namespace model\Entity;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class BrandsEntity extends EntityScheme {
    public $brand_id;
	public $brand_name;
	public $brand_image;
	public $brand_link;

    public function model() {
        return new \model\Brands();
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->brand_id)->Content($this->brand_name);
    }


    protected function dictionary(): array {
        return  [
            'brand_id' => 'brand_id',
            'brand_name' => 'brand_name',
            'brand_image'=>'brand_image',
            'brand_link'=>'brand_link'
        ];
    }
}
