<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ContactUsEntity extends EntityScheme
{
    public $contact_us_id;
    public $contact_us_address;
    public $contact_us_email;
    public $contact_us_mobile;
    public $contact_us_phone;
    public $contact_us_facebook;
    public $contact_us_instagram;
    public $contact_us_whatsapp;
    public $contact_us_telegram;

    public function model()
    {
        return new \model\ContactUs();
    }

    public function apiFormat()
    {
        return[
          'address'=>$this->contact_us_address,
          'email'=>$this->contact_us_email,
          'mobile'=>$this->contact_us_mobile,
          'phone'=>$this->contact_us_phone,
          'facebook'=>$this->contact_us_facebook,
          'instagram'=>$this->contact_us_instagram,
          'whatsapp'=>$this->contact_us_whatsapp,
          'telegram'=>$this->contact_us_telegram,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'contact_us_id'=>'contact_us_id',
            'contact_us_address'=>'contact_us_address',
            'contact_us_email'=>'contact_us_email',
            'contact_us_mobile'=>'contact_us_mobile',
            'contact_us_phone'=>'contact_us_phone',
            'contact_us_facebook'=>'contact_us_facebook',
            'contact_us_instagram'=>'contact_us_instagram',
            'contact_us_whatsapp'=>'contact_us_whatsapp',
            'contact_us_telegram'=>'contact_us_telegram',
        ];
    }

}
