<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Districts;
use model\States;

class CustomerAddressesEntity extends EntityScheme {
	public $customer_address_id;
	public $customer_id;
	public $customer_address_name;
	public $state_id;
	public $city_id;
	public $district_id;
	public $customer_address;
	public $customer_postcode;
	public $customer_address_latitude;
	public $customer_address_longitude;


	public function model() {
		return new \model\CustomerAddresses();
	}

//    public function toOption(): Option
//    {
//        return HtmlTags::Option()->Value($this->customer_address_id)->Content($this->customer_address);
//    }

    public function toOption(): Option
    {
        $state = States::get($this->state_id);
        $city = Cities::get($this->city_id);
        $district = Districts::get($this->district_id);
        return HtmlTags::Option()->Value($this->customer_address_id)->Content($state->state_name.' - '.$city->city_name.' - '.$district->district_name.' - '.$this->customer_address.' کدپستی: '.$this->customer_postcode);
    }

    protected function dictionary() : array {
		return [
            'customer_address_id'=>'customer_address_id',
            'customer_id'=>'customer_id',
            'customer_address_name'=>'customer_address_name',
            'state_id'=>'state_id',
            'city_id'=>'city_id',
            'district_id'=>'district_id',
            'customer_address'=>'customer_address',
            'customer_postcode'=>'customer_postcode',
            'customer_address_latitude'=>'customer_address_latitude',
            'customer_address_longitude'=>'customer_address_longitude',
		];
	}

}
