<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class DownloadCategoriesEntity extends EntityScheme
{
   public $category_id;
   public $category_name;

    public function model()
    {
        return new \model\DownloadCategories();
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->category_id)->Content($this->category_name);
    }

    public function apiFormat()
    {
        return[
          'id'=>$this->category_id,
          'name'=>$this->category_name
        ];
    }

    protected function dictionary(): array
    {
        return [
            'category_id'=>'category_id',
            'category_name'=>'category_name',
        ];
    }

}
