<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class DownloadsEntity extends EntityScheme
{
    public $download_id;
    /**
    عنوان بلاگ
     **/
    public $title;
    /**
    دسته بندی
     **/
    public $group_id;
    /**
    برچسب ها
     **/
    public $tag_id;
    /**
    تاریخ
     **/
    public $date;
    /**
    تصویر
     **/
    public $image;
    /**
    تصویر
     **/
    public $file;
    /**
    توضیح خاص
     **/
    public $brief;
    /**
    توضیح کامل
     **/
    public $description;
    /**
    تعداد بازدید
     **/
    public $views;


    public function model()
    {
        return new \model\Downloads();
    }

    public function apiFormat()
    {
        return [
            'id' => $this->download_id,
            'categoryId'=>$this->category_id,
            'category'=>\model\DownloadCategories::get($this->category_id)->category_name,
            'title' => $this->download_title,
            'text' => $this->download_text,
            'image' => 'https://zamanzeevar.negarine.com/admin/src/images/Downloads/' . $this->download_image,
            'file' => 'https://zamanzeevar.negarine.com/admin/src/images/Downloads/' . $this->download_file
        ];
    }


    protected function dictionary(): array
    {
        return  [
            'download_id' => 'download_id',
            'title' => 'download_title',
            'group_id' => 'download_group_id',
            'tag_id' => 'download_tag_id',
            'date' => 'download_date',
            'image' => 'download_image',
            'file' => 'download_file',
            'brief' => 'download_brief',
            'description' => 'download_description',
            'views' => 'download_views',
        ];
    }

}
