<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class LevelsEntity extends EntityScheme
{
    public $level_id;
    public $level_name;
    public $discount_percent;
    public $least_price;

    public function model()
    {
        return new \model\Levels();
    }
    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->level_id)->Content($this->level_name);
    }


    protected function dictionary(): array
    {
        return [
         'level_id'=>'level_id',
         'level_name'=>'level_name',
         'discount_percent'=>'discount_percent',
         'least_price'=>'least_price',
        ];
    }

}
