<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class CustomersEntity extends EntityScheme {
    public $customer_id;
    public $customer_first_name;
    public $customer_last_name;
    public $customer_mobile;
    public $customer_gender;
    public $customer_password;
    public $customer_avatar;
    public $customer_code;
    public $customer_status;
    public $customer_total_pay;
    public $customer_credit;
    public $customer_level_id;
    public $set_level;

	public function model() {
		return new \model\Customers();
	}


    public function toOption() : Option {
        return HtmlTags::Option()->Value($this->customer_id)->Content($this->customer_first_name.' '.$this->customer_last_name);
    }

    public function apiFormat()
    {
        return [
            'customerId' => $this->customer_id,
            'customerFirstName' => $this->customer_first_name,
            'customerLastName' => $this->customer_last_name,
            'customerGender' => $this->customer_gender,
            'mobile' => $this->customer_mobile,
            'avatar' => $this->customer_avatar ? "https://zamanzeevar.negarine.com/admin/src/images/Customers/" . $this->customer_avatar : "",
            'customerTotalPayments'=>$this->customer_total_pay,
            'customerCredit'=>$this->customer_credit,
            'levelId'=>$this->customer_level_id
        ];
    }

    protected function dictionary() : array {
		return [
			'customer_id'=>'customer_id',
			'customer_first_name'=>'customer_first_name',
			'customer_last_name'=>'customer_last_name',
			'customer_mobile'=>'customer_mobile',
			'customer_gender'=>'customer_gender',
			'customer_password'=>'customer_password',
			'customer_avatar'=>'customer_avatar',
			'customer_code'=>'customer_code',
			'customer_status'=>'customer_status',
			'customer_credit'=>'customer_credit',
		];
	}
}
