<?php
namespace model\Entity;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class PartnersEntity extends EntityScheme {
    public $partner_id;
	/**
	نام
	**/
	public $first_name;
	/**
	نام خانوادگی
	**/
	public $last_name;
	/**
	نام فروشگاه
	**/
	public $shop_name;
	/**
	تلفن همراه
	**/
	public $mobile;
	/**
	کد ملی
	**/
	public $national_code;
	/**
	تلفن فروشگاه
	**/
	public $tel;
	/**
	کلمه عبور
	**/
	public $password;
	/**
	آدرس فروشگاه
	**/
	public $state_id;
	public $city_id;
	public $district_id;
	public $address_latitude;
	public $address_longitude;
	public $address;
	public $user_id;

    public function model() {
        return new \model\Partners();
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->partner_id)->Content($this->shop_name.' ('.$this->first_name.' '.$this->last_name.' )');
    }

    protected function dictionary(): array {
        return  [
            'partner_id' => 'partner_id',
            'first_name' => 'first_name',
            'last_name' => 'last_name',
            'shop_name' => 'shop_name',
            'mobile' => 'mobile',
            'national_code' => 'national_code',
            'tel' => 'tel',
            'password' => 'password',
            'state_id' => 'state_id',
            'city_id' => 'city_id',
            'district_id' => 'district_id',
            'address_latitude' => 'address_latitude',
            'address_longitude' => 'address_longitude',
            'address' => 'address',
            'user_id' => 'user_id',
        ];
    }
}
