<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class ProductInformationsEntity extends EntityScheme
{
   public $product_information_id;
   public $category_id;
   public $product_information_name;

    public function model()
    {
        return new \model\ProductInformations();
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->product_information_id)->Content($this->product_information_name);
    }


    protected function dictionary(): array
    {
        return [
           'product_information_id'=>'product_information_id',
           'category_id'=>'category_id',
           'product_information_name'=>'product_information_name'
        ];
    }

}
