<?php

namespace model\Entity;

use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Cities;
use FwHtml\Elements\Tags\Option;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class ProductsEntity extends EntityScheme {
	public $product_id;
	public $product_name;
	public $brand_id;
	public $product_price;
	public $product_image;
	public $product_details;
	public $product_brief;
	public $cat_id;
	public $sub_cats;
	public $tag_ids;
	public $product_views;
	public $product_sales;
	public $product_amount;
    public $date_create;
    /**
     * @var void
     */


    public function model() {
		return new \model\Products();
	}

    public function apiFormat()
    {
        $Categories = [$this->cat_id];
        foreach (json_decode($this->sub_cats) as $item){
            $int = intval($item);
            $Categories[]=$int;
        }
        return[
            'id'=>$this->product_id,
            'name'=>$this->product_name,
            'price'=>$this->product_price,
            'image'=>$this->product_image?"https://zamanzeevar.negarine.com/admin/src/images/Products/".$this->product_image:"",
            'brief'=>$this->product_brief,
            'details'=>$this->product_details,
            'categories'=>$Categories
        ];
    }

    public function torobApiFormat()
    {
        $Categories = [$this->cat_id];
        foreach (json_decode($this->sub_cats) as $item){
            $int = intval($item);
            $Categories[]=$int;
        }
        return[
            'id'=>$this->product_id,
            'name'=>$this->product_name,
            'price'=>$this->product_price,
            'image'=>$this->product_image?"https://zamanzeevar.negarine.com/admin/src/images/Products/".$this->product_image:"",
            'link'=>"https://zamanzeevar.negarine.com/products/".$this->product_id."/".str_replace(' ', '-', $this->product_name),
            'details'=>$this->product_brief,
            'date'=>$this->date_create,
        ];
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->product_id)->Content($this->product_name);
    }

    protected function dictionary() : array {
		return [
            'product_id'=>'product_id',
            'product_name'=>'product_name',
            'brand_id'=>'brand_id',
            'product_price'=>'product_price',
            'product_image'=>'product_image',
            'product_brief'=>'product_brief',
            'product_details'=>'product_details',
            'cat_id'=>'cat_id',
            'sub_cats'=>'sub_cats',
            'tag_ids'=>'tag_ids',
            'product_views'=>'product_views',
            'product_sales'=>'product_sales',
            'product_amount'=>'product_amount',
            'date_create'=>'date_create',
		];
	}


}
