<?php
namespace model\Entity;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class TagsEntity extends EntityScheme {
    public $tag_id;
	public $tag_name;

    public function model() {
        return new \model\Tags();
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->tag_id)->Content($this->tag_name);
    }


    protected function dictionary(): array {
        return  [
            'tag_id' => 'tag_id',
            'tag_name' => 'tag_name',
        ];
    }
}
