<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TicketsEntity extends EntityScheme
{
    public $ticket_id;
    public $customer_id;
    public $ticket_name;
    public $ticket_email;
    public $ticket_text;
    public $ticket_answer;


    public function model()
    {
        return new \model\Tickets();
    }

    public function apiFormat()
    {
        return[
            'text'=>$this->ticket_text,
            'answer'=>$this->ticket_answer?:"",
        ];
    }


    protected function dictionary(): array
    {
        return [
            'ticket_id'=>'ticket_id',
            'customer_id'=>'customer_id',
            'ticket_name'=>'ticket_name',
            'ticket_email'=>'ticket_email',
            'ticket_text'=>'ticket_text',
            'ticket_answer'=>'ticket_answer',
        ];
    }

}
