<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">

            <div class="col-sm-6 d-flex">

                <h1 class="m-0 text-dark">خوش آمدید!</h1>

            </div>

            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="#">خانه</a></li>
                    <li class="breadcrumb-item active">داشبورد مدیریتی</li>
                </ol>
            </div>
        </div>
        <div class="row">
            <?php
            $user = \FwAuthSystem\Main\UserObject::instance();

            use FwHtml\Elements\Tags\Main\HtmlTags;
            use model\Entity\PartnersEntity;

            function addCard(string $showNumber, string $nameFiled, string $link, string $id, string $color) {
                echo HtmlTags::Div('.col-lg-2.col-6')->Content(
                    HtmlTags::Div('.small-box.' . $color . '')->Content(
                        HtmlTags::Div('.inner.text-center')->Content(
                            HtmlTags::H3($showNumber),
                            HtmlTags::P($nameFiled)
                        ),
                        HtmlTags::A('.small-box-footer.ajax')->Rel($link)->Content(
                            'اطلاعات بیشتر',
                            HtmlTags::I('.fa.fa-arrow-circle-left.mr-1')
                        )->Id($id)
                    )
                );
            }

            function addCard2(string $showNumber, string $nameFiled, string $link, string $id, string $color) {
                echo HtmlTags::Div('.col-lg-3.col-6')->Content(
                    HtmlTags::Div('.small-box.' . $color . '')->Content(
                        HtmlTags::Div('.inner.text-center')->Content(
                            HtmlTags::H3(number_format($showNumber)),
                            HtmlTags::P($nameFiled)
                        ),
                        HtmlTags::A('.small-box-footer.ajax')->Rel($link)->Content(
                            'اطلاعات بیشتر',
                            HtmlTags::I('.fa.fa-arrow-circle-left.mr-1')
                        )->Id($id)
                    )
                );
            }

            function addCard3(string $showNumber, string $nameFiled, string $link, string $id, string $color) {
                echo HtmlTags::Div('.col-lg-3.col-6')->Content(
                    HtmlTags::Div('.small-box.' . $color . '')->Content(

                        HtmlTags::A('.small-box-footer.ajax')->Rel($link)->Content(
                            $nameFiled,
                            HtmlTags::I('.fa.fa-arrow-circle-left.mr-1')
                        )->Id($id)
                    )
                );
            }
            if($user->getRole() == 'PartnerRole'){
                /** @var PartnersEntity $partner */
                $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
                $partnerId = $partner['partner_id'];
                addCard2(\model\PartnerStocks::Db()->custom("select distinct product_id from tblPartnerStocks where partner_id =  '$partnerId'")->rowCount(), 'محصولات موجود در انبار '. $user->getName(), 'PartnerStocks', '', 'bg-success');
                addCard2(\model\DepositeStocks::Db()->custom("select distinct product_id from tblDepositeStocks where partner_id =  '$partnerId'")->rowCount(), 'محصولات موجود در انبار امانی', 'DepositeStocks', '', 'bg-success');
                addCard2(\model\Orders::Db()->custom("select sum(payment_price) as total from tblOrders where (stock_id = '$partnerId')")->get()->first->total, 'فروش کل ', 'Orders', '', 'bg-success');
                addCard2(\model\Orders::Db()->custom("select * from tblOrders where (stock_id = '$partnerId')")->rowCount(), 'تعداد فاکتور', 'Orders', '', 'bg-success');

            } else {
                addCard(\model\Products::Db()->rowCount(), 'کل محصولات',  'Products', '', 'bg-success');
                addCard(\model\MainStocks::Db()->custom('select distinct product_id from tblMainStocks')->rowCount(), 'محصولات موجود در انبار اصلی', 'MainStocks', '', 'bg-success');
                addCard(\model\PartnerStocks::Db()->custom('select distinct product_id from tblPartnerStocks')->rowCount(), 'محصولات موجود در انبار نمایندگان', 'PartnerStocks', '', 'bg-success');
                addCard(\model\DepositeStocks::Db()->custom('select distinct product_id from tblDepositeStocks')->rowCount(), 'محصولات موجود در انبار امانی', 'DepositeStocks', '', 'bg-success');
                addCard(\model\Partners::Db()->rowCount(), 'نمایندگان', 'DepositeStocks', '', 'bg-success');
                addCard(\model\Customers::Db()->rowCount(), 'مشتریان', 'DepositeStocks', '', 'bg-success');

                addCard2(\model\Orders::Db()->custom('select sum(payment_price) as total from tblOrders where order_payment_type = 1')->get()->first->total, 'فروش کل (نقدی)', 'Orders', '', 'bg-info');
                addCard2(\model\Orders::Db()->custom('select sum(payment_price) as total from tblOrders where order_payment_type = 2 or order_payment_type = 3')->get()->first->total, 'فروش کل (بانکی)', 'Orders', '', 'bg-info');
                addCard2(\model\Orders::Db()->custom('select sum(payment_price) as total from tblOrders where order_payment_type = 4')->get()->first->total, 'فروش کل (اعتباری)', 'Orders', '', 'bg-info');
                addCard2(\model\Orders::Db()->custom('select sum(payment_price) as total from tblOrders where order_payment_type = 5')->get()->first->total, 'فروش کل (اقساطی)', 'Orders', '', 'bg-info');
            }


//            addCard3(\model\Orders::Db()->custom('select sum(payment_price) as total from tblOrders where order_payment_type = 5')->get()->first->total, 'فروش کل (اقساطی)', 'Orders', '', 'bg-info');

            echo HtmlTags::Div('.col-12')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                HtmlTags::H4('آخرین فاکتورهای فروش'),

                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-primary')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام خریدار'),
                                                                    HtmlTags::Th('مبلغ فاکتور'),
                                                                    HtmlTags::Th('تاریخ فاکتور'),
                                                                    HtmlTags::Th('وضعیت پرداخت'),
                                                                    HtmlTags::Th('نحوه پرداخت'),
                                                                    HtmlTags::Th('.no-sort مشاهده')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                function (){
                                                                    $output=[];
                                                                    $i = 1;
                                                                    $user = \FwAuthSystem\Main\UserObject::instance();
                                                                    if($user->getRole() == 'PartnerRole'){
                                                                        /** @var PartnersEntity $partner */
                                                                        $partner = \model\Partners::Db()->where("user_id", $user->getUserId())->get()->first();
                                                                        $partnerId = $partner['partner_id'];
                                                                        echo $partnerId;
                                                                        $orders = \model\Orders::db()->where("stock_id" , $partner->partner_id)->get()->sortBy('order_date', true);
                                                                    } else {
                                                                        $orders = \model\Orders::getAll()->sortBy('order_date', true);
                                                                    }


                                                                    foreach ($orders as $order){
                                                                        $customer = \model\Customers::get($order->customer_id);
                                                                        $date = jdate('Y/m/d<br/>H:i', $order->order_date);
                                                                        switch ($order->order_payment_type){
                                                                            case 0:
                                                                                $paymentType = "پرداخت نشده";
                                                                                break;
                                                                            case 1:
                                                                                $paymentType = "پرداخت نقدی";
                                                                                break;
                                                                            case 2:
                                                                                $paymentType = "خرید آنلاین";
                                                                                break;
                                                                            case 3:
                                                                                $paymentType = "واریز به حساب";
                                                                                break;
                                                                            case 4:
                                                                                $paymentType = "خرید اعتباری";
                                                                                break;
                                                                            case 5:
                                                                                $paymentType = "خرید اقساطی";
                                                                                break;
                                                                            case 6:
                                                                                $paymentType = "هدیه";
                                                                                break;
                                                                        }

                                                                        switch ($order->order_status){
                                                                            case 0:
                                                                                $orderType = "ثبت سفارش";
                                                                                break;
                                                                            case 1:
                                                                                $orderType = "پرداخت شده";
                                                                                break;
                                                                            case 2:
                                                                                $orderType = "ارسال شده";
                                                                                break;
                                                                            case 3:
                                                                                $orderType = "تحویل شده";
                                                                                break;
                                                                            case 4:
                                                                                $orderType = "لغو شده";
                                                                                break;

                                                                        }
                                                                        $name = $customer->customer_first_name . ' ' . $customer->customer_last_name;
                                                                        $output[]=HtmlTags::Tr()->Content(
                                                                            HtmlTags::Td()->Content("$i"),
                                                                            HtmlTags::Td()->Content("$name"),
                                                                            HtmlTags::Td()->Content(price_format($order->total_price)),
                                                                            HtmlTags::Td()->Content("$date"),
                                                                            HtmlTags::Td()->Content("$orderType"),
                                                                            HtmlTags::Td()->Content("$paymentType"),
                                                                            HtmlTags::Td()->Content(
                                                                                HtmlTags::A('.btn.btn-outline-info.p-2.ajax')->Rel("^editIndex^Orders/Orders?order_id=$order->order_id")->Content(
                                                                                    HtmlTags::I('.fa.fa-eye.mr-1')
                                                                                )
                                                                            ),

                                                                        );
                                                                        $i++;
                                                                    }
                                                                    return implode("",$output);
                                                                }
                                                            )
                                                    )
                                            )
                                    )
                            )
                        );
            ?>
        </div>
    </div>
</div>

