<?php

use FwHtml\FontAwesome as Fa;
$user = \FwAuthSystem\Main\UserObject::instance();
$SideBar = new Sidebar(true);

if($user->getRole() == "AdminRole") {
    $SideBar->Item('مشتریان', Fa::Users())->_items([
        MenuItem::create('سطوح عضویت', Fa::Users())->LinksTo(controller\Levels::class),
        MenuItem::create('مدیریت مشتریان', Fa::Users())->LinksTo(controller\Customers::class),
        MenuItem::create('آدرس مشتریان', Fa::Users())->LinksTo(controller\CustomerAddresses::class)
    ]);

    $SideBar->Item('امور نمایندگان', Fa::Users())->_items([
        MenuItem::create('مدیریت نمایندگان', Fa::Users())->LinksTo(controller\Partners::class),
    ]);

}

if($user->getRole() == "AdminRole" || $user->getRole() == "CommerceRole" || $user->getRole() == "PartnerRole") {

    $SideBar->Item('انبارها', Fa::Location_arrow())->_items([

        $user->getRole() != "PartnerRole" ? MenuItem::create('انبار اصلی', Fa::Product_hunt())->LinksTo(controller\MainStocks::class) : null,
        MenuItem::create('انبار امانی', Fa::Product_hunt())->LinksTo(controller\DepositeStocks::class),
        $user->getRole() != "PartnerRole" ? MenuItem::create('انبار نمایندگان', Fa::Product_hunt())->LinksTo(controller\PartnerStocks::class) : MenuItem::create('انبار ' . $user->getName(), Fa::Product_hunt())->LinksTo(controller\PartnerStocks::class),
        MenuItem::create(' حواله های خروجی از انبار', Fa::Tachometer())->_items([
            $user->getRole() != "PartnerRole" ? MenuItem::create('خروجی از انبار اصلی ', Fa::Area_chart())->LinksTo(controller\mainStockReports::RelPath([], 'outStock')) : null,
            MenuItem::create('خروجی از انبار امانی ', Fa::Bar_chart())->LinksTo(controller\DepositeStocksReports::RelPath([], 'outStock')),
            $user->getRole() != "PartnerRole" ? MenuItem::create('خروجی از انبار نمایندگان', Fa::Pie_chart())->LinksTo(controller\PartnerStocksReports::RelPath([], 'outStock')) : MenuItem::create('خروجی از انبار ' . $user->getName(), Fa::Pie_chart())->LinksTo(controller\PartnerStocksReports::RelPath([], 'outStock')),

        ]),

        MenuItem::create(' حواله های ورودی به انبار', Fa::Tachometer())->_items([
            $user->getRole() != "PartnerRole" ? MenuItem::create('ابتدای دوره ', Fa::Area_chart())->LinksTo(controller\mainStockReports::RelPath([], 'beginPeriod')) : null,
            $user->getRole() != "PartnerRole" ? MenuItem::create('ورودی به انبار اصلی ', Fa::Area_chart())->LinksTo(controller\mainStockReports::RelPath([], 'inStock')) : null,
            MenuItem::create('ورودی به انبار امانی ', Fa::Bar_chart())->LinksTo(controller\DepositeStocksReports::RelPath([], 'inStock')),
            $user->getRole() != "PartnerRole" ? MenuItem::create('ورودی به انبار نمایندگان', Fa::Pie_chart())->LinksTo(controller\PartnerStocksReports::RelPath([], 'inStock')) : MenuItem::create('ورودی به انبار ' . $user->getName(), Fa::Pie_chart())->LinksTo(controller\PartnerStocksReports::RelPath([], 'inStock')),

        ]),

    ]);

    $SideBar->Item('سفارشات', Fa::List())->_items([
        MenuItem::create('ثبت سفارش', Fa::List())->LinksTo(controller\addOrder::class),
        MenuItem::create('سفارشات ثبت شده', Fa::List())->LinksTo(controller\Orders::class),
    ]);
}
if($user->getRole() == "AdminRole" || $user->getRole() == "CommerceRole") {
    $SideBar->Item('اطلاعات پایه', Fa::List())->_items([
        MenuItem::create('دسته بندی', Fa::List())->LinksTo(controller\Categories::class),
        MenuItem::create('مرتب سازی دسته بندی های اصلی', Fa::List())->LinksTo(controller\Sort::class),
        MenuItem::create('روشهای توزیع', Fa::List())->LinksTo(controller\Distributions::class),
    ]);

    $SideBar->Item('مدیریت محصولات', Fa::Shopping_basket())->_items([
        MenuItem::create('محصولات', Fa::Product_hunt())->LinksTo(controller\Products::class),

        MenuItem::create('برچسب ها', Fa::Tags())->LinksTo(controller\Tags::class),
        MenuItem::create('برند ها', Fa::Apple())->LinksTo(controller\Brands::class),
        MenuItem::create('گالری محصولات', Fa::Picture_o())->LinksTo(controller\ProductPhotos::class),
        MenuItem::create('مشخصات فنی', Fa::Wrench())->LinksTo(controller\ProductInformations::class),
        MenuItem::create('مقادیر مشخصات فنی', Fa::Wrench())->LinksTo(controller\ProductInformationValues::class),
        MenuItem::create('مدیریت کد تخفیف', Fa::Percent())->LinksTo(controller\Discounts::class),
        MenuItem::create('مدیریت فروش ویژه', Fa::Percent())->LinksTo(controller\SpecialOffers::class),
    ]);
}

if($user->getRole() == "AdminRole" || $user->getRole() == "ContentRole") {
    $SideBar->Item('مدیریت سایت', Fa::Internet_explorer())->_items([
        MenuItem::create('اسلایدر ها', Fa::File_image_o())->LinksTo(controller\Banners::class),
        MenuItem::create('تماس با ما', Fa::Phone())->LinksTo(controller\ContactUs::class),
        MenuItem::create('درباره ما', Fa::Question())->LinksTo(controller\AboutUs::class),
        MenuItem::create('پیام ها', Fa::Envelope())->LinksTo(controller\Messages::class),
        MenuItem::create('خدمات', Fa::Wrench())->LinksTo(controller\Services::class),
        MenuItem::create('بنر های میانی سایت', Fa::Picture_o())->LinksTo(controller\MiddleSiteBanners::class),
        MenuItem::create('بنر های ویژگی ها', Fa::Picture_o())->LinksTo(controller\AttributeBanners::class),
    ]);

    $SideBar->Item('مدیریت مقالات', Fa::Newspaper_o())->_items([
        MenuItem::create('دسته بندی مقالات', Fa::List())->LinksTo(controller\BlogCategories::class),
        MenuItem::create('برچسب مقالات', Fa::List())->LinksTo(controller\BlogTags::class),
        MenuItem::create('مقالات', Fa::Newspaper_o())->LinksTo(controller\Blogs::class),
    ]);

    $SideBar->Item('مدیریت دانلودها', Fa::Newspaper_o())->_items([
        MenuItem::create('دسته بندی دانلودها', Fa::List())->LinksTo(controller\DownloadCategories::class),
        MenuItem::create('برچسب دانلودها', Fa::List())->LinksTo(controller\DownloadTags::class),
        MenuItem::create('دانلودها', Fa::Newspaper_o())->LinksTo(controller\Downloads::class),
    ]);
}

if($user->getRole() == "AdminRole" || $user->getRole() == "FinancialRole") {
    $SideBar->Item('گزارشات مالی', Fa::Exchange())->_items([
        MenuItem::create('فاکتورهای فروش', Fa::Pie_chart())->LinksTo(controller\InvoiceReports::class),
//        MenuItem::create('فاکتور خرید', Fa::Bar_chart()),
        MenuItem::create('برگشت از فروش', Fa::Area_chart())->LinksTo(\controller\InvoiceBackReports::class),
//        MenuItem::create('برگشت از خرید', Fa::Line_chart()),
        MenuItem::create('انتقال بین انبارها', Fa::Pie_chart())->LinksTo(controller\TransferReports::class),
        MenuItem::create('ورود و خروج کالا', Fa::Bar_chart())->LinksTo(controller\ProductFollowReports::class),
        MenuItem::create('دریافت از مشتریان', Fa::Area_chart())->LinksTo(controller\ReciveReports::class),
        MenuItem::create('پرداخت به مشتریان', Fa::Line_chart())->LinksTo(controller\PaymentReports::class),
            ]);
}
if($user->getRole() == "AdminRole") {
    $SideBar->Item('اطلاعات جغرافیایی', Fa::Location_arrow())->_items([
        MenuItem::create('استان ها', Fa::Location_arrow())->LinksTo(controller\States::class),
        MenuItem::create('شهر ها', Fa::Location_arrow())->LinksTo(controller\Cities::class),
        MenuItem::create('مناطق', Fa::Location_arrow())->LinksTo(controller\Districts::class),
    ]);

    $SideBar->Item('کاربران سیستم', Fa::Users())->_items([
        MenuItem::create('مدیریت کاربران', Fa::Users())->LinksTo(controller\UsersTable::class),
    ]);
    $SideBar->Item('Tools', Fa::Wrench())->_items([
        MenuItem::create('QUERY BUILDER', Fa::Times_circle_o())
            ->LinksTo('QueryBuilder/QueryBuilder.fwTools'),
        MenuItem::create('MODEL GENERATOR', Fa::Times_circle_o())
            ->LinksTo('modelGenerator/modelGenerator.fwTools'),
        MenuItem::create('Form Generator', Fa::Times_circle_o())
            ->LinksTo('formGenerator/formGenerator.fwTools'),
        MenuItem::create('Data seeder', Fa::Times_circle_o())
            ->LinksTo('DataSeeder/DataSeeder.fwTools'),
    ]);
}
$SideBar->render();
