<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class PhotosMigration extends Migratable {
    const modelName = 'Photos';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('photo_id');
			$blueprint->VarChar('photo_name')->Len(150);
			$blueprint->Int('photo_group_id')->Len(150);
			$blueprint->Int('photo_visits')->Len(150);
			$blueprint->VarChar('photo_image')->Len(150);

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
