<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AboutUsMigration extends Migratable {
    const modelName = 'AboutUs';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('about_u_id');
			$blueprint->VarChar('about_us_title')->Len(150);
			$blueprint->VarChar('about_us_image')->Len(150);
			$blueprint->Text('about_us_details');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
